/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.analytics;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.HashMap;
import org.appcelerator.titanium.analytics.TiAnalyticsEvent;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class TiAnalyticsModel
extends SQLiteOpenHelper {
    private static final String LCAT = "TiAnalyticsDb";
    private static final String DB_NAME = "tianalytics.db";
    private static final int DB_VERSION = 4;

    public TiAnalyticsModel(Context context) {
        super(context, DB_NAME, null, 4);
    }

    public void onCreate(SQLiteDatabase db) {
        Log.d(LCAT, "Creating Database tianalytics.db");
        String sql = "create table Events (  _id INTEGER PRIMARY KEY,   EventId TEXT,   Name TEXT,   Timestamp TEXT,   MID TEXT,   SID TEXT,   isJSON INTEGER,   Payload TEXT );";
        db.execSQL(sql);
        this.onUpgrade(db, 1, 4);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(LCAT, "Upgrading Database from " + oldVersion + " to " + newVersion);
        int version = oldVersion;
        block5: while (version < newVersion) {
            switch (version) {
                case 1: {
                    this.doMigration_1(db);
                    version = 2;
                    continue block5;
                }
                case 2: {
                    this.doMigration_2(db);
                    version = 3;
                    continue block5;
                }
                case 3: {
                    this.doMigration_3(db);
                    version = 4;
                    continue block5;
                }
            }
            throw new IllegalStateException("Missing migration path version=" + version);
        }
    }

    private void doMigration_1(SQLiteDatabase db) {
        String sql = "drop table if exists Events";
        db.execSQL(sql);
        sql = "create table Events (  _id INTEGER PRIMARY KEY AUTOINCREMENT,   EventId TEXT,   Name TEXT,   Timestamp TEXT,   MID TEXT,   SID TEXT,   AppID TEXT,   isJSON INTEGER,   Payload TEXT );";
        db.execSQL(sql);
    }

    private void doMigration_2(SQLiteDatabase db) {
        String sql = "create table Props (  _id INTEGER PRIMARY KEY,   Name TEXT,   Value TEXT );";
        db.execSQL(sql);
        sql = "insert into Props(Name, Value) values ('Enrolled', '0')";
        db.execSQL(sql);
    }

    private void doMigration_3(SQLiteDatabase db) {
        String sql = "drop table if exists Events";
        db.execSQL(sql);
        sql = "create table Events (  _id INTEGER PRIMARY KEY AUTOINCREMENT,   EventId TEXT,   Type TEXT,   Event TEXT,   Timestamp TEXT,   MID TEXT,   SID TEXT,   AppGUID TEXT,   isJSON INTEGER,   Payload TEXT );";
        db.execSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(TiAnalyticsEvent event) {
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
            String sql = "insert into Events(EventId, Type, Event, Timestamp, MID, SID, AppGUID, isJSON, Payload) values(?,?,?,?,?,?,?,?,?)";
            Object[] args = new Object[]{TiPlatformHelper.createEventId(), event.getEventType(), event.getEventEvent(), event.getEventTimestamp(), event.getEventMid(), event.getEventSid(), event.getEventAppGuid(), event.mustExpandPayload() ? 1 : 0, event.getEventPayload()};
            db.execSQL(sql, args);
        }
        catch (SQLException e) {
            Log.e(LCAT, "Error adding event: " + (Object)((Object)e));
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEvents(int[] records) {
        if (records.length > 0) {
            SQLiteDatabase db = null;
            try {
                db = this.getWritableDatabase();
                StringBuilder sb = new StringBuilder(256);
                sb.append("delete from Events where _id in (");
                for (int i = 0; i < records.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(records[i]);
                }
                sb.append(")");
                db.execSQL(sb.toString());
            }
            catch (SQLException e) {
                Log.e(LCAT, "Error deleting events :" + (Object)((Object)e));
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEvents() {
        boolean result = false;
        SQLiteDatabase db = null;
        Cursor c = null;
        try {
            db = this.getReadableDatabase();
            String sql = "select exists(select _id from Events)";
            c = db.rawQuery(sql, null);
            if (c.moveToNext()) {
                result = c.getInt(0) != 0;
            }
        }
        catch (SQLException e) {
            Log.e(LCAT, "Error determining if there are events to send: ", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, JSONObject> getEventsAsJSON(int limit) {
        HashMap<Integer, JSONObject> result = new HashMap<Integer, JSONObject>(limit);
        SQLiteDatabase db = null;
        Cursor c = null;
        try {
            db = this.getReadableDatabase();
            String sql = "select _id, EventId, Type, Event, Timestamp, MID, SID, AppGUID, isJSON, Payload from Events  order by 1 limit " + limit;
            c = db.rawQuery(sql, null);
            while (c.moveToNext()) {
                boolean isJSON;
                int seq = c.getInt(0);
                JSONObject json = new JSONObject();
                json.put("seq", seq);
                json.put("ver", (Object)"2");
                json.put("id", (Object)c.getString(1));
                json.put("type", (Object)c.getString(2));
                json.put("event", (Object)c.getString(3));
                json.put("ts", (Object)c.getString(4));
                json.put("mid", (Object)c.getString(5));
                json.put("sid", (Object)c.getString(6));
                json.put("aguid", (Object)c.getString(7));
                boolean bl = isJSON = c.getInt(8) == 1;
                if (isJSON) {
                    json.put("data", (Object)new JSONObject(c.getString(9)));
                } else {
                    json.put("data", (Object)c.getString(9));
                }
                result.put(seq, json);
            }
        }
        catch (JSONException e) {
            Log.e(LCAT, "Error creating JSON.", e);
        }
        catch (SQLException e) {
            Log.e(LCAT, "Error retrieving events to send as JSON: ", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsEnrollEvent() {
        boolean result = false;
        SQLiteDatabase db = null;
        Cursor c = null;
        try {
            db = this.getReadableDatabase();
            String sql = "select Value from Props where Name = 'Enrolled'";
            c = db.rawQuery(sql, null);
            if (c.moveToNext()) {
                result = c.getInt(0) == 0;
            }
        }
        catch (SQLException e) {
            Log.e(LCAT, "Error retrieving events to send as JSON: ", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEnrolled() {
        String sql = "update Props set Value = '1' where Name = 'Enrolled'";
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
            db.execSQL(sql);
        }
        catch (SQLException e) {
            Log.e(LCAT, "Error marking enrolled :" + (Object)((Object)e));
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

