/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.analytics;

import android.content.Context;
import android.location.Location;
import java.util.GregorianCalendar;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.analytics.TiAnalyticsEvent;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiDatabaseHelper;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class TiAnalyticsEventFactory {
    private static final String LCAT = "TiAnalyticsEventFactory";
    public static final String EVENT_APP_ENROLL = "ti.enroll";
    public static final String EVENT_APP_START = "ti.start";
    public static final String EVENT_APP_END = "ti.end";
    public static final String EVENT_ERROR = "ti.crash";
    public static final String EVENT_APP_GEO = "ti.geo";
    public static final long MAX_GEO_ANALYTICS_FREQUENCY = 60000L;
    protected static Location lastLocation;

    public static TiAnalyticsEvent createAppEnrollEvent(TiApplication tiApp, String deployType) {
        TiAnalyticsEvent event = null;
        TiDatabaseHelper db = new TiDatabaseHelper((Context)tiApp);
        try {
            JSONObject json = new JSONObject();
            json.put("mac_addr", (Object)TiPlatformHelper.getMacaddress());
            json.put("app_name", (Object)tiApp.getAppInfo().getName());
            json.put("oscpu", TiPlatformHelper.getProcessorCount());
            json.put("platform", (Object)TiPlatformHelper.getName());
            json.put("app_id", (Object)tiApp.getAppInfo().getId());
            json.put("ostype", (Object)TiPlatformHelper.getOstype());
            json.put("osarch", (Object)TiPlatformHelper.getArchitecture());
            json.put("model", (Object)TiPlatformHelper.getModel());
            json.put("previous_mid", (Object)db.getPlatformParam("previous_machine_id", "notfound"));
            json.put("deploytype", (Object)deployType);
            event = new TiAnalyticsEvent(EVENT_APP_ENROLL, EVENT_APP_ENROLL, json);
        }
        catch (JSONException e) {
            Log.e(LCAT, "Unable to encode start event", e);
            event = null;
        }
        return event;
    }

    public static TiAnalyticsEvent createAppStartEvent(TiApplication application, String deployType) {
        TiAnalyticsEvent event = null;
        try {
            JSONObject json = new JSONObject();
            json.put("tz", GregorianCalendar.getInstance().getTimeZone().getRawOffset() / 60000);
            json.put("deploytype", (Object)deployType);
            json.put("os", (Object)TiPlatformHelper.getModel());
            json.put("osver", (Object)TiPlatformHelper.getVersion());
            json.put("version", (Object)application.getTiBuildVersion());
            json.put("un", (Object)TiPlatformHelper.getUsername());
            json.put("app_version", (Object)application.getAppInfo().getVersion());
            json.put("nettype", (Object)TiPlatformHelper.getNetworkTypeName());
            event = new TiAnalyticsEvent(EVENT_APP_START, EVENT_APP_START, json);
        }
        catch (JSONException e) {
            Log.e(LCAT, "Unable to encode start event", e);
            event = null;
        }
        return event;
    }

    public static TiAnalyticsEvent createAppEndEvent() {
        return new TiAnalyticsEvent(EVENT_APP_END, EVENT_APP_END, "");
    }

    public static TiAnalyticsEvent createErrorEvent(Thread t, Throwable err, String tiVersionInfo) {
        TiAnalyticsEvent event = null;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("thread_name").append(t.getName()).append("\n").append("thread_id").append(t.getId()).append("\n").append("error_msg").append(err.toString()).append("\n").append("ti_version").append(tiVersionInfo).append("\n").append("<<<<<<<<<<<<<<< STACK TRACE >>>>>>>>>>>>>>>").append("\n");
        StackTraceElement[] elements = err.getStackTrace();
        int len = elements.length;
        for (int i = 0; i < len; ++i) {
            sb.append(elements[i].toString()).append("\n");
        }
        event = new TiAnalyticsEvent(EVENT_ERROR, EVENT_ERROR, sb.toString());
        sb.setLength(0);
        sb = null;
        return event;
    }

    public static TiAnalyticsEvent createAppGeoEvent(Location location) {
        TiAnalyticsEvent result = null;
        if (lastLocation == null || location.getTime() - lastLocation.getTime() > 60000L) {
            try {
                JSONObject wrapper = new JSONObject();
                wrapper.put("to", (Object)TiAnalyticsEventFactory.locationToJSONObject(location));
                if (lastLocation != null) {
                    wrapper.put("from", (Object)TiAnalyticsEventFactory.locationToJSONObject(lastLocation));
                } else {
                    wrapper.put("from", null);
                }
                result = new TiAnalyticsEvent(EVENT_APP_GEO, EVENT_APP_GEO, wrapper);
                lastLocation = location;
            }
            catch (JSONException e) {
                Log.e(LCAT, "Error building ti.geo event", e);
            }
        }
        return result;
    }

    protected static JSONObject locationToJSONObject(Location loc) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("latitude", loc.getLatitude());
        result.put("longitude", loc.getLongitude());
        result.put("altitude", loc.getAltitude());
        result.put("accuracy", (double)loc.getAccuracy());
        result.put("altitudeAccuracy", null);
        result.put("heading", (double)loc.getBearing());
        result.put("speed", (double)loc.getSpeed());
        result.put("timestamp", loc.getTime());
        return result;
    }

    public static TiAnalyticsEvent createEvent(String type, String event, String data) {
        try {
            JSONObject o = new JSONObject(data);
            return new TiAnalyticsEvent(type, event, o);
        }
        catch (JSONException e) {
            Log.w(LCAT, "data object was not JSON, sending as string");
            return new TiAnalyticsEvent(type, event, data);
        }
    }
}

