/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.analytics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class TiAnalyticsEvent {
    private static final String LCAT = "TitaniumAnalyticsEvent";
    private static TimeZone utc = TimeZone.getTimeZone("utc");
    private static SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private String eventType;
    private String eventEvent;
    private String eventTimestamp;
    private String eventMid;
    private String eventSid;
    private String eventPayload;
    private String eventAppGuid;
    private boolean expandPayload;

    TiAnalyticsEvent(String eventType, String eventEvent, String eventPayload) {
        try {
            JSONObject o = new JSONObject();
            o.put("value", (Object)eventPayload);
            this.init(eventType, eventEvent, o);
        }
        catch (JSONException e) {
            Log.e(LCAT, "Error packaging string.", e);
            this.init(eventType, eventEvent, new JSONObject());
        }
    }

    TiAnalyticsEvent(String eventType, String eventEvent, JSONObject eventPayload) {
        this.init(eventType, eventEvent, eventPayload);
    }

    private void init(String eventType, String eventEvent, JSONObject eventPayload) {
        this.eventType = eventType;
        this.eventEvent = eventEvent;
        this.eventTimestamp = TiAnalyticsEvent.getTimestamp();
        this.eventMid = TiPlatformHelper.getMobileId();
        this.eventSid = TiPlatformHelper.getSessionId();
        this.eventAppGuid = TiPlatformHelper.getAppInfo().getGUID();
        this.eventPayload = eventPayload.toString();
        this.expandPayload = true;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventEvent() {
        return this.eventEvent;
    }

    public String getEventTimestamp() {
        return this.eventTimestamp;
    }

    public String getEventMid() {
        return this.eventMid;
    }

    public String getEventSid() {
        return this.eventSid;
    }

    public String getEventAppGuid() {
        return this.eventAppGuid;
    }

    public String getEventPayload() {
        return this.eventPayload;
    }

    public boolean mustExpandPayload() {
        return this.expandPayload;
    }

    public static String getTimestamp() {
        return isoDateFormatter.format(new Date());
    }

    static {
        isoDateFormatter.setTimeZone(utc);
    }
}

