/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import java.util.Collection;
import java.util.HashMap;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public abstract class TiStylesheet {
    private static final String TAG = "TiStylesheet";
    private static final boolean DBG = TiConfig.DEBUG;
    protected final HashMap<String, HashMap<String, KrollDict>> classesMap = new HashMap();
    protected final HashMap<String, HashMap<String, KrollDict>> idsMap = new HashMap();
    protected final HashMap<String, HashMap<String, HashMap<String, KrollDict>>> classesDensityMap = new HashMap();
    protected final HashMap<String, HashMap<String, HashMap<String, KrollDict>>> idsDensityMap = new HashMap();

    protected void addAll(KrollDict result, HashMap<String, KrollDict> map, String key) {
        KrollDict d;
        if (map != null && (d = map.get(key)) != null) {
            result.putAll(d);
        }
    }

    public final KrollDict getStylesheet(String objectId, Collection<String> classes, String density, String basename) {
        HashMap<String, KrollDict> globalDensityMap;
        if (DBG) {
            Log.d(TAG, "getStylesheet id: " + objectId + ", classes: " + classes + ", density: " + density + ", basename: " + basename);
        }
        KrollDict result = new KrollDict();
        if (this.classesMap != null) {
            HashMap<String, KrollDict> classMap = this.classesMap.get(basename);
            HashMap<String, KrollDict> globalMap = this.classesMap.get("global");
            if (globalMap != null || classMap != null) {
                for (String clazz : classes) {
                    this.addAll(result, globalMap, clazz);
                    this.addAll(result, classMap, clazz);
                }
            }
        }
        if (this.classesDensityMap != null) {
            globalDensityMap = null;
            if (this.classesDensityMap.containsKey("global")) {
                globalDensityMap = this.classesDensityMap.get("global").get(density);
            }
            HashMap<String, KrollDict> classDensityMap = null;
            if (this.classesDensityMap.containsKey(basename)) {
                classDensityMap = this.classesDensityMap.get(basename).get(density);
            }
            if (globalDensityMap != null || classDensityMap != null) {
                for (String clazz : classes) {
                    this.addAll(result, globalDensityMap, clazz);
                    this.addAll(result, classDensityMap, clazz);
                }
            }
        }
        if (this.idsMap != null && objectId != null) {
            this.addAll(result, this.idsMap.get("global"), objectId);
            this.addAll(result, this.idsMap.get(basename), objectId);
        }
        if (this.idsDensityMap != null && objectId != null) {
            globalDensityMap = null;
            if (this.idsDensityMap.containsKey("global")) {
                globalDensityMap = this.idsDensityMap.get("global").get(density);
            }
            HashMap<String, KrollDict> idDensityMap = null;
            if (this.idsDensityMap.containsKey(basename)) {
                idDensityMap = this.idsDensityMap.get(basename).get(density);
            }
            this.addAll(result, globalDensityMap, objectId);
            this.addAll(result, idDensityMap, objectId);
        }
        return result;
    }
}

