/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.appcelerator.titanium.util.Log;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TiScriptRunner {
    private static final String TAG = "TiScriptRunner";
    private static TiScriptRunner _instance;
    protected String appPackageName;
    protected HashMap<String, TiScript> scripts = new HashMap();

    public static TiScriptRunner getInstance() {
        if (_instance == null) {
            _instance = new TiScriptRunner();
        }
        return _instance;
    }

    public static void main(Script script, String[] args) {
        TiScriptRunner runner = TiScriptRunner.getInstance();
        String scriptClassName = args[0];
        TiScript tiScript = runner.scripts.get(scriptClassName);
        tiScript.script = script;
        tiScript.returnValue = runner.executeScript(tiScript);
    }

    private TiScriptRunner() {
    }

    protected Object executeScript(TiScript script) {
        Log.d(TAG, "Executing script: " + script.name);
        Object returnValue = Scriptable.NOT_FOUND;
        try {
            returnValue = script.script.exec(script.context, script.scope);
        }
        catch (RhinoException e) {
            Log.e(TAG, "Javascript Exception: " + e.getMessage(), e);
            Context.reportRuntimeError((String)e.getMessage(), (String)e.sourceName(), (int)e.lineNumber(), (String)e.lineSource(), (int)e.columnNumber());
        }
        script.context = null;
        script.scope = null;
        return returnValue;
    }

    protected String getScriptClassName(String relativePath) {
        String scriptClassName = new String(relativePath);
        scriptClassName = scriptClassName.replace(".js", "").replace("/", "_").replace("\\", "_").replace(" ", "_").replace(".", "_").replace("-", "_");
        return this.appPackageName + ".js." + scriptClassName;
    }

    public void setAppPackageName(String packageName) {
        this.appPackageName = packageName;
    }

    public Object runScript(Context context, Scriptable scope, String relativePath) throws ClassNotFoundException {
        String scriptClassName = this.getScriptClassName(relativePath);
        if (this.scripts.containsKey(scriptClassName)) {
            TiScript script = this.scripts.get(scriptClassName);
            script.context = context;
            script.scope = scope;
            return this.executeScript(script);
        }
        TiScript script = new TiScript();
        script.context = context;
        script.scope = scope;
        script.name = scriptClassName;
        Class<?> scriptClass = Class.forName(scriptClassName);
        try {
            Method mainMethod = scriptClass.getMethod("main", String[].class);
            if (mainMethod != null) {
                this.scripts.put(scriptClassName, script);
                mainMethod.invoke(null, new Object[]{new String[]{scriptClassName}});
                Object returnValue = script.returnValue;
                script.returnValue = null;
                return returnValue;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return ScriptableObject.NOT_FOUND;
    }

    protected class TiScript {
        public Context context;
        public Scriptable scope;
        public String name;
        public Script script;
        public Object returnValue;

        protected TiScript() {
        }
    }
}

