/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFastDev;
import org.appcelerator.titanium.TiLaunchActivity;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiRHelper;
import org.appcelerator.titanium.view.ITiWindowHandler;

public class TiRootActivity
extends TiLaunchActivity
implements TiActivitySupport,
ITiWindowHandler {
    private static final String LCAT = "TiRootActivity";
    private static final boolean DBG = TiConfig.LOGD;

    @Override
    public String getUrl() {
        return "app.js";
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getTiApp().setCurrentActivity(this, this);
        Log.checkpoint(LCAT, "checkpoint, on root activity create, savedInstanceState: " + savedInstanceState);
        TiApplication app = this.getTiApp();
        app.setRootActivity(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onResume() {
        Log.checkpoint(LCAT, "checkpoint, on root activity resume. context = " + this.tiContext);
        super.onResume();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        try {
            Drawable d;
            int backgroundId = TiRHelper.getResource("drawable.background");
            if (backgroundId != 0 && (d = this.getResources().getDrawable(backgroundId)) != null) {
                Drawable bg = this.getWindow().getDecorView().getBackground();
                this.getWindow().setBackgroundDrawable(d);
                bg.setCallback(null);
            }
        }
        catch (Exception e) {
            Log.e(LCAT, "Resource not found 'drawable.background': " + e.getMessage());
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (DBG) {
            Log.d(LCAT, "root activity onDestroy, context = " + this.tiContext);
        }
        if (this.tiContext != null) {
            TiApplication app = this.tiContext.getTiApp();
            if (app != null) {
                app.releaseModules();
            }
            this.tiContext.release();
        }
        TiFastDev.onDestroy();
    }

    @Override
    public TiContext getTiContext() {
        return this.tiContext;
    }
}

