/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiProperties {
    private static final String LCAT = "TiProperties";
    public static boolean DBG;
    SharedPreferences preferences;

    public TiProperties(Context context, String name, boolean clear) {
        this.preferences = context.getSharedPreferences(name, 0);
        if (clear) {
            this.preferences.edit().clear().commit();
        }
    }

    public String getString(String key, String def) {
        if (DBG) {
            Log.d(LCAT, "getString called with key:" + key + ", def:" + def);
        }
        if (!this.preferences.contains(key)) {
            return def;
        }
        return this.preferences.getAll().get(key).toString();
    }

    public void setString(String key, String value) {
        if (DBG) {
            Log.d(LCAT, "setString called with key:" + key + ", value:" + value);
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        if (value == null) {
            editor.remove(key);
        } else {
            editor.putString(key, value);
        }
        editor.commit();
    }

    public int getInt(String key, int def) {
        if (DBG) {
            Log.d(LCAT, "getInt called with key:" + key + ", def:" + def);
        }
        return this.preferences.getInt(key, def);
    }

    public void setInt(String key, int value) {
        if (DBG) {
            Log.d(LCAT, "setInt called with key:" + key + ", value:" + value);
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public double getDouble(String key, double def) {
        if (DBG) {
            Log.d(LCAT, "getDouble called with key:" + key + ", def:" + def);
        }
        if (!this.hasProperty(key)) {
            return def;
        }
        String stringValue = this.preferences.getString(key, "");
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public void setDouble(String key, double value) {
        if (DBG) {
            Log.d(LCAT, "setDouble called with key:" + key + ", value:" + value);
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(key, value + "");
        editor.commit();
    }

    public boolean getBool(String key, boolean def) {
        if (DBG) {
            Log.d(LCAT, "getBool called with key:" + key + ", def:" + def);
        }
        return this.preferences.getBoolean(key, def);
    }

    public void setBool(String key, boolean value) {
        if (DBG) {
            Log.d(LCAT, "setBool called with key:" + key + ", value:" + value);
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public String[] getList(String key, String[] def) {
        int length;
        if (DBG) {
            Log.d(LCAT, "getList called with key:" + key + ", def:" + def);
        }
        if ((length = this.preferences.getInt(key + ".length", -1)) == -1) {
            return def;
        }
        String[] list = new String[length];
        for (int i = 0; i < length; ++i) {
            list[i] = this.preferences.getString(key + "." + i, "");
        }
        return list;
    }

    public void setList(String key, String[] value) {
        if (DBG) {
            Log.d(LCAT, "setList called with key:" + key + ", value:" + value);
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        for (int i = 0; i < value.length; ++i) {
            editor.putString(key + "." + i, value[i]);
        }
        editor.putInt(key + ".length", value.length);
        editor.commit();
    }

    public boolean hasListProperty(String key) {
        return this.hasProperty(key + ".0");
    }

    public boolean hasProperty(String key) {
        return this.preferences.contains(key);
    }

    public String[] listProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (String key : this.preferences.getAll().keySet()) {
            if (key.endsWith(".length")) {
                properties.add(key.substring(0, key.length() - 7));
                continue;
            }
            if (key.matches(".+\\.\\d+$")) continue;
            properties.add(key);
        }
        return properties.toArray(new String[properties.size()]);
    }

    public void removeProperty(String key) {
        if (this.preferences.contains(key)) {
            SharedPreferences.Editor editor = this.preferences.edit();
            editor.remove(key);
            editor.commit();
        }
    }

    static {
        if (TiConfig.LOGD) {
            // empty if block
        }
        DBG = false;
    }
}

