/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiMessageQueue
implements Handler.Callback {
    private static final String TAG = "TiMessageQueue";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int MSG_RUN = 3000;
    public static final int DEFAULT_TIMEOUT = 50;
    protected static ThreadLocal<TiMessageQueue> threadLocalQueue = new ThreadLocal<TiMessageQueue>(){

        @Override
        protected TiMessageQueue initialValue() {
            TiMessageQueue queue = new TiMessageQueue();
            if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
                mainQueue = queue;
            }
            return queue;
        }
    };
    protected static TiMessageQueue mainQueue;
    protected ArrayBlockingQueue<Message> messageQueue = new ArrayBlockingQueue(10);
    protected CountDownLatch blockingLatch;
    protected AtomicInteger blockCount = new AtomicInteger(0);
    protected Handler handler = new Handler((Handler.Callback)this);
    protected Handler.Callback callback;

    protected TiMessageQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiMessageQueue getMessageQueue() {
        if (Looper.myLooper() == null) {
            ThreadLocal<TiMessageQueue> threadLocal = threadLocalQueue;
            synchronized (threadLocal) {
                if (Looper.myLooper() == null) {
                    Looper.prepare();
                }
            }
        }
        return threadLocalQueue.get();
    }

    public static TiMessageQueue getMainMessageQueue() {
        return mainQueue;
    }

    public void sendMessage(Message msg) {
        Handler target = msg.getTarget();
        long currentThreadId = Thread.currentThread().getId();
        long targetThreadId = -1L;
        if (target != null) {
            targetThreadId = target.getLooper().getThread().getId();
        }
        if (target != null && currentThreadId == targetThreadId) {
            target.dispatchMessage(msg);
        } else if (this.isBlocking()) {
            try {
                this.messageQueue.put(msg);
            }
            catch (InterruptedException e) {
                Log.w(TAG, "interrupted trying to put new message, sending to handler", e);
                msg.sendToTarget();
            }
        } else {
            msg.sendToTarget();
        }
    }

    public Object sendBlockingMessage(Message msg, AsyncResult result) {
        return this.sendBlockingMessage(msg, TiMessageQueue.getMessageQueue(), result);
    }

    public Object sendBlockingMessage(Message msg, TiMessageQueue blockQueue, final AsyncResult asyncResult) {
        AsyncResult blockingResult = new AsyncResult(asyncResult.getArg()){

            @Override
            public Object getResult() {
                int timeout = 0;
                try {
                    while (!this.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                        if (TiMessageQueue.this.messageQueue.size() == 0) {
                            timeout = 50;
                            continue;
                        }
                        TiMessageQueue.this.dispatchPendingMessages();
                    }
                }
                catch (InterruptedException e) {
                    Log.e(TiMessageQueue.TAG, "interrupted waiting for async result", e);
                    TiMessageQueue.this.dispatchPendingMessages();
                }
                if (this.exception != null) {
                    throw new RuntimeException(this.exception);
                }
                return this.result;
            }

            @Override
            public void setResult(Object result) {
                super.setResult(result);
                asyncResult.setResult(result);
            }
        };
        this.blockCount.incrementAndGet();
        msg.obj = blockingResult;
        blockQueue.sendMessage(msg);
        Object o = blockingResult.getResult();
        this.blockCount.decrementAndGet();
        this.dispatchPendingMessages();
        return o;
    }

    public void setCallback(Handler.Callback callback) {
        this.callback = callback;
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 3000) {
            ((Runnable)msg.obj).run();
            return true;
        }
        if (this.callback != null) {
            return this.callback.handleMessage(msg);
        }
        return false;
    }

    public void post(Runnable runnable) {
        this.sendMessage(this.handler.obtainMessage(3000, (Object)runnable));
    }

    public void resetLatch() {
        this.blockingLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking() {
        TiMessageQueue tiMessageQueue = this;
        synchronized (tiMessageQueue) {
            if (this.isBlocking()) {
                return;
            }
            this.resetLatch();
            this.blockCount.incrementAndGet();
        }
        int timeout = 0;
        try {
            while (!this.blockingLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                if (this.messageQueue.size() == 0) {
                    timeout = 50;
                    continue;
                }
                this.dispatchPendingMessages();
            }
        }
        catch (InterruptedException e) {
            Log.e(TAG, "interrupted while blocking", e);
        }
        this.dispatchPendingMessages();
        this.blockCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBlocking() {
        TiMessageQueue tiMessageQueue = this;
        synchronized (tiMessageQueue) {
            if (this.blockingLatch != null) {
                this.blockingLatch.countDown();
            }
        }
    }

    public boolean isBlocking() {
        return this.blockCount.get() > 0;
    }

    public void dispatchPendingMessages() {
        while (this.dispatchMessage()) {
        }
    }

    public boolean dispatchMessage() {
        Message msg = this.messageQueue.poll();
        if (msg == null) {
            return false;
        }
        if (msg.getTarget() != null) {
            msg.getTarget().dispatchMessage(msg);
            return true;
        }
        return false;
    }

    public boolean dispatchMessage(int timeout, TimeUnit unit) {
        try {
            Message msg = this.messageQueue.poll(timeout, unit);
            if (msg != null) {
                if (DBG) {
                    Log.d(TAG, "Dispatching message: " + msg);
                }
                if (msg.getTarget() != null) {
                    msg.getTarget().dispatchMessage(msg);
                    return true;
                }
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public Handler getHandler() {
        return this.handler;
    }
}

