/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import java.io.IOException;
import java.util.Set;
import org.appcelerator.titanium.ITiAppInfo;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiProperties;
import org.appcelerator.titanium.analytics.TiAnalyticsEventFactory;
import org.appcelerator.titanium.proxy.ActivityProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBindingHelper;
import org.appcelerator.titanium.util.TiColorHelper;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiUrl;
import org.appcelerator.titanium.view.TiCompositeLayout;

public abstract class TiLaunchActivity
extends TiBaseActivity {
    private static final String TAG = "TiLaunchActivity";
    private static final boolean DBG = TiConfig.LOGD;
    protected TiContext tiContext;
    protected TiUrl url;
    protected AlertDialog noLaunchCategoryAlert;

    public abstract String getUrl();

    protected void scriptLoaded() {
    }

    protected void contextCreated() {
    }

    public TiContext getTiContext() {
        return this.tiContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadActivityScript() {
        try {
            String fullUrl = this.url.resolve(this.tiContext);
            if (DBG) {
                Log.d(TAG, "Eval JS Activity:" + fullUrl);
            }
            this.tiContext.evalFile(fullUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.finish();
        }
        finally {
            if (DBG) {
                Log.d(TAG, "Signal JS loaded");
            }
            this.messageQueue.stopBlocking();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.getIntent();
        if (intent != null && this.checkMissingLauncher(intent, savedInstanceState)) {
            return;
        }
        this.url = TiUrl.normalizeWindowUrl(this.getUrl());
        this.tiContext = TiContext.createTiContext(this, this.url.baseUrl, this.url.url);
        this.tiContext.setLaunchContext(true);
        if (this.activityProxy == null) {
            this.setActivityProxy(new ActivityProxy(this.tiContext, this));
        }
        TiApplication tiApp = this.getTiApp();
        Activity tempCurrentActivity = tiApp.getCurrentActivity();
        tiApp.setCurrentActivity(this, this);
        TiBindingHelper.bindCurrentActivity(this.tiContext, this.activityProxy);
        tiApp.setCurrentActivity(this, tempCurrentActivity);
        this.contextCreated();
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void windowCreated() {
        ITiAppInfo appInfo = this.getTiApp().getAppInfo();
        this.getIntent().putExtra("fullscreen", appInfo.isFullscreen());
        this.getIntent().putExtra("navBarHidden", appInfo.isNavBarHidden());
        super.windowCreated();
        this.loadActivityScript();
        this.scriptLoaded();
    }

    protected boolean checkMissingLauncher(Intent intent, Bundle savedInstanceState) {
        String action = intent.getAction();
        if (action != null && action.equals("android.intent.action.MAIN")) {
            Set categories = intent.getCategories();
            boolean b2373Detected = true;
            if (categories != null) {
                for (String category : categories) {
                    if (!category.equals("android.intent.category.LAUNCHER")) continue;
                    b2373Detected = false;
                    break;
                }
            }
            if (b2373Detected) {
                Log.e(TAG, "Android issue 2373 detected (missing intent CATEGORY_LAUNCHER), restarting app.");
                this.layout = new TiCompositeLayout((Context)this);
                this.setContentView((View)this.layout);
                this.activityOnCreate(savedInstanceState);
                return true;
            }
        }
        return false;
    }

    protected void alertMissingLauncher() {
        TiProperties systemProperties = this.getTiApp().getSystemProperties();
        String backgroundColor = systemProperties.getString("ti.android.bug2373.backgroundColor", "black");
        this.layout.setBackgroundColor(TiColorHelper.parseColor(backgroundColor));
        DialogInterface.OnClickListener restartListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                TiLaunchActivity.this.restartActivity(500);
            }
        };
        String title = systemProperties.getString("ti.android.bug2373.title", "Restart Required");
        String message = systemProperties.getString("ti.android.bug2373.message", "An application restart is required");
        String buttonText = systemProperties.getString("ti.android.bug2373.buttonText", "Continue");
        this.noLaunchCategoryAlert = new AlertDialog.Builder((Context)this).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)buttonText, restartListener).setCancelable(false).create();
        this.noLaunchCategoryAlert.show();
    }

    protected void restartActivity(int delay) {
        Intent relaunch = new Intent(this.getApplicationContext(), this.getClass());
        relaunch.setAction("android.intent.action.MAIN");
        relaunch.addCategory("android.intent.category.LAUNCHER");
        AlarmManager am = (AlarmManager)this.getSystemService("alarm");
        if (am != null) {
            PendingIntent pi = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)relaunch, (int)0x40000000);
            am.set(1, System.currentTimeMillis() + (long)delay, pi);
        }
        this.finish();
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        TiProperties systemProperties = this.getTiApp().getSystemProperties();
        boolean restart = systemProperties.getBool("ti.android.root.reappears.restart", false);
        if (restart) {
            Log.w(TAG, "Tasks may have been destroyed by Android OS for inactivity. Restarting.");
            this.restartActivity(250);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.tiContext != null) {
            this.tiContext.fireLifecycleEvent(this, 0);
        }
    }

    @Override
    protected void onResume() {
        if (this.tiContext == null) {
            this.alertMissingLauncher();
        } else {
            this.tiContext.fireLifecycleEvent(this, 1);
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        if (this.tiContext == null) {
            if (this.noLaunchCategoryAlert != null && this.noLaunchCategoryAlert.isShowing()) {
                this.noLaunchCategoryAlert.cancel();
                this.noLaunchCategoryAlert = null;
            }
            this.finish();
        } else {
            this.tiContext.fireLifecycleEvent(this, 2);
        }
        super.onPause();
    }

    @Override
    protected void onStop() {
        if (this.tiContext != null) {
            this.tiContext.fireLifecycleEvent(this, 3);
        }
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        if (this.tiContext != null) {
            this.tiContext.fireLifecycleEvent(this, 4);
            TiApplication tiApp = this.tiContext.getTiApp();
            if (tiApp != null) {
                tiApp.postAnalyticsEvent(TiAnalyticsEventFactory.createAppEndEvent());
            }
        }
        super.onDestroy();
    }
}

