/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiDeployData;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiStreamHelper;
import org.appcelerator.titanium.util.TiTempFileHelper;

public class TiFastDev {
    private static final String TAG = "TiFastDev";
    private static final boolean DBG = TiConfig.LOGD;
    private static TiFastDev _instance;
    private static final String EMULATOR_HOST = "10.0.2.2";
    private static final int FASTDEV_PORT = 7999;
    private static final String TEMP_FILE_PREFIX = "tifastdev";
    private static final String TEMP_FILE_SUFFIX = "tmp";
    public static final String COMMAND_LENGTH = "length";
    public static final String COMMAND_GET = "get";
    public static final String COMMAND_HANDSHAKE = "handshake";
    public static final String COMMAND_KILL = "kill";
    public static final String COMMAND_RESTART = "restart";
    public static final String COMMAND_SHUTDOWN = "shutdown";
    public static final String UTF8_CHARSET = "UTF-8";
    public static final String RESULT_OK = "OK";
    public static final int MAX_TOKEN_COUNT = 16;
    protected boolean enabled = false;
    protected boolean listen = false;
    protected int port = -1;
    protected String urlPrefix;
    protected Socket fastDevSocket;
    protected Session session;
    protected boolean restarting = false;
    protected TiTempFileHelper tempHelper;

    public static TiFastDev getInstance() {
        if (_instance == null) {
            _instance = new TiFastDev();
        }
        return _instance;
    }

    public TiFastDev() {
        TiDeployData deployData;
        TiApplication app = TiApplication.getInstance();
        if (app == null) {
            return;
        }
        this.tempHelper = app.getTempFileHelper();
        if (app.isFastDevMode() && (deployData = app.getDeployData()) != null) {
            this.enabled = true;
            this.readDeployData(deployData);
            if (this.enabled && this.fastDevSocket != null) {
                this.session = new Session();
                this.session.executeHandshake();
                this.session.start();
            }
        }
    }

    protected void readDeployData(TiDeployData deployData) {
        this.port = deployData.getFastDevPort();
        this.listen = deployData.getFastDevListen();
        if (this.listen) {
            Log.d(TAG, "Enabling Fastdev in listening mode...");
            this.acceptConnection();
        } else if (this.port != -1) {
            Log.d(TAG, "Enabling Fastdev on port " + this.port);
            this.connect();
        } else {
            this.enabled = false;
        }
    }

    protected void acceptConnection() {
        try {
            ServerSocket server = new ServerSocket(7999);
            this.fastDevSocket = server.accept();
        }
        catch (IOException e) {
            Log.w(TAG, e.getMessage(), e);
            this.enabled = false;
            this.showDisabledWarning(e);
        }
    }

    protected void connect() {
        try {
            this.fastDevSocket = new Socket(EMULATOR_HOST, this.port);
        }
        catch (Exception e) {
            Log.w(TAG, e.getMessage(), e);
            this.enabled = false;
            this.showDisabledWarning(e);
        }
    }

    protected void showToast(String message) {
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
        TiRootActivity ctx = TiApplication.getInstance().getRootActivity();
        Toast toast = Toast.makeText((Context)ctx, (CharSequence)message, (int)1);
        toast.show();
    }

    protected void showDisabledWarning(Exception e) {
        this.showToast("Warning: FastDev mode is disabled. Error Message: " + e.getMessage());
    }

    public String toURL(String relativePath) {
        return this.urlPrefix + "/" + relativePath;
    }

    public int getLength(String relativePath) {
        byte[][] result = this.session.sendMessage(COMMAND_LENGTH, relativePath);
        if (result != null && result.length > 0) {
            return this.session.toInt(result[0]);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(String relativePath) {
        Session session = this.session;
        synchronized (session) {
            this.session.checkingForMessage = false;
            this.session.sendTokens(COMMAND_GET, relativePath);
            int tokenCount = this.session.readTokenCount();
            if (tokenCount < 1) {
                return null;
            }
            int length = this.session.readInt();
            if (length <= 0) {
                return null;
            }
            try {
                File tempFile = this.tempHelper.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
                FileOutputStream tempOut = new FileOutputStream(tempFile);
                TiStreamHelper.pumpCount(this.session.getInputStream(), tempOut, length);
                tempOut.close();
                this.session.checkingForMessage = true;
                return new FileInputStream(tempFile);
            }
            catch (FileNotFoundException e) {
                Log.e(TAG, e.getMessage(), e);
            }
            catch (IOException e) {
                Log.e(TAG, e.getMessage(), e);
            }
        }
        return null;
    }

    public static boolean isFastDevEnabled() {
        return TiFastDev.getInstance().isEnabled();
    }

    public static void onDestroy() {
        if (_instance != null && TiFastDev._instance.restarting) {
            TiFastDev._instance.restarting = false;
            return;
        }
        if (_instance != null && TiFastDev._instance.session != null) {
            TiFastDev._instance.session.close();
            TiFastDev._instance.session = null;
        }
        _instance = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected class Session
    extends Thread {
        protected InputStream in;
        protected OutputStream out;
        protected boolean connected = true;
        protected boolean checkingForMessage = false;

        public Session() {
            try {
                this.in = TiFastDev.this.fastDevSocket.getInputStream();
                this.out = TiFastDev.this.fastDevSocket.getOutputStream();
            }
            catch (IOException e) {
                Log.e(TiFastDev.TAG, e.getMessage(), e);
            }
        }

        public InputStream getInputStream() {
            return this.in;
        }

        protected boolean blockRead(byte[] buffer) {
            try {
                int bytesRead = 0;
                while (bytesRead < buffer.length) {
                    int read = this.in.read(buffer, bytesRead, buffer.length - bytesRead);
                    if (read < 0) {
                        return false;
                    }
                    if ((bytesRead += read) != buffer.length) continue;
                    return true;
                }
            }
            catch (IOException e) {
                Log.e(TiFastDev.TAG, e.getMessage(), e);
            }
            return false;
        }

        protected int toInt(byte[] data) {
            return (data[0] << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        }

        protected byte[] toBytes(int data) {
            byte[] bytes = new byte[]{(byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), (byte)data};
            return bytes;
        }

        protected int readInt() {
            byte[] buffer = new byte[4];
            if (this.blockRead(buffer)) {
                return this.toInt(buffer);
            }
            return -1;
        }

        protected byte[] readToken() {
            byte[] tokenData;
            int length = this.readInt();
            if (length > 0 && this.blockRead(tokenData = new byte[length])) {
                return tokenData;
            }
            return null;
        }

        @Override
        public void run() {
            while (this.connected) {
                try {
                    if (DBG) {
                        Log.d(TiFastDev.TAG, "checking for message? " + this.checkingForMessage);
                    }
                    if (this.checkingForMessage && this.in.available() > 0) {
                        byte[][] message = this.readMessage();
                        if (message == null) break;
                        this.execute(message);
                    }
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    Log.e(TiFastDev.TAG, e.getMessage(), e);
                }
            }
        }

        protected void handshakeError(String guid, String result) {
            Log.e(TiFastDev.TAG, "Fastdev session didn't receive the correct handshake (sent: " + guid + ", result: " + result + "), aborting.");
            this.connected = false;
            TiFastDev.this.enabled = false;
        }

        protected void executeHandshake() {
            String guid = TiApplication.getInstance().getAppInfo().getGUID();
            byte[][] resultData = this.sendMessage(TiFastDev.COMMAND_HANDSHAKE, guid);
            if (resultData == null) {
                this.handshakeError(guid, null);
                return;
            }
            String result = new String(resultData[0]);
            if (!result.equals(TiFastDev.RESULT_OK)) {
                this.handshakeError(guid, result);
            } else {
                Log.d(TiFastDev.TAG, "Fastdev session handshake succesful.");
            }
        }

        protected int readTokenCount() {
            int tokenCount = this.readInt();
            if (tokenCount > 0) {
                if (tokenCount > 16) {
                    return -1;
                }
                return tokenCount;
            }
            return -1;
        }

        protected byte[][] readMessage() {
            int tokenCount = this.readTokenCount();
            if (tokenCount > 0) {
                byte[][] tokens = new byte[tokenCount][];
                for (int i = 0; i < tokenCount; ++i) {
                    tokens[i] = this.readToken();
                }
                return tokens;
            }
            return null;
        }

        protected void execute(byte[][] message) {
            try {
                String command = new String(message[0], TiFastDev.UTF8_CHARSET);
                if (DBG) {
                    Log.d(TiFastDev.TAG, "Execute command: " + command);
                }
                if (TiFastDev.COMMAND_KILL.equals(command)) {
                    this.executeKill();
                } else if (TiFastDev.COMMAND_RESTART.equals(command)) {
                    this.executeRestart();
                }
            }
            catch (UnsupportedEncodingException e) {
                Log.e(TiFastDev.TAG, e.getMessage(), e);
            }
        }

        protected void executeKill() {
            String message = "Killing app from Fastdev server request";
            Log.w(TiFastDev.TAG, message);
            TiFastDev.this.showToast(message);
            this.sendTokens(TiFastDev.RESULT_OK);
            Process.killProcess((int)Process.myPid());
        }

        protected void executeRestart() {
            String message = "Restarting app from Fastdev server request";
            Log.w(TiFastDev.TAG, message);
            TiFastDev.this.showToast(message);
            TiFastDev.this.restarting = true;
            this.sendTokens(TiFastDev.RESULT_OK);
            TiApplication app = TiApplication.getInstance();
            Intent i = app.getPackageManager().getLaunchIntentForPackage(app.getPackageName());
            i.addFlags(0x4000000);
            i.addCategory("android.intent.category.LAUNCHER");
            app.getRootActivity().startActivity(i);
        }

        protected boolean sendTokens(String ... tokens) {
            try {
                byte[] tokenLen = this.toBytes(tokens.length);
                this.out.write(tokenLen);
                for (String token : tokens) {
                    byte[] data = token.getBytes(TiFastDev.UTF8_CHARSET);
                    byte[] len = this.toBytes(data.length);
                    this.out.write(len);
                    this.out.write(data);
                }
                return true;
            }
            catch (IOException e) {
                Log.e(TiFastDev.TAG, e.getMessage(), e);
                return false;
            }
        }

        public synchronized byte[][] sendMessage(String ... tokens) {
            this.checkingForMessage = false;
            if (this.sendTokens(tokens)) {
                byte[][] message = this.readMessage();
                Log.d(TiFastDev.TAG, "sent tokens successfully");
                this.checkingForMessage = true;
                return message;
            }
            Log.d(TiFastDev.TAG, "error sending tokens");
            this.checkingForMessage = true;
            return null;
        }

        public void close() {
            this.connected = false;
            if (TiFastDev.this.fastDevSocket != null) {
                try {
                    TiFastDev.this.fastDevSocket.close();
                    TiFastDev.this.fastDevSocket = null;
                }
                catch (IOException e) {
                    Log.e(TiFastDev.TAG, e.getMessage(), e);
                }
            }
        }
    }
}

