/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiDimension {
    private static final String LCAT = "TiDimension";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int COMPLEX_UNIT_UNDEFINED = 16;
    public static final int COMPLEX_UNIT_PERCENT = 17;
    public static final int COMPLEX_UNIT_AUTO = 18;
    public static final int TYPE_LEFT = 0;
    public static final int TYPE_CENTER_X = 1;
    public static final int TYPE_RIGHT = 2;
    public static final int TYPE_TOP = 3;
    public static final int TYPE_CENTER_Y = 4;
    public static final int TYPE_BOTTOM = 5;
    public static final int TYPE_WIDTH = 6;
    public static final int TYPE_HEIGHT = 7;
    public static final double POINT_DPI = 72.0;
    public static final double MM_INCH = 25.4;
    public static Pattern DIMENSION_PATTERN = Pattern.compile("(-?[0-9]*\\.?[0-9]+)\\s*(px|dp|dip|sp|sip|mm|pt|in|%)?");
    protected static DisplayMetrics metrics = null;
    protected double value;
    protected int units;
    protected int valueType;

    public TiDimension(double value, int valueType) {
        this.value = value;
        this.valueType = valueType;
        this.units = 16;
    }

    public TiDimension(String svalue, int valueType) {
        this.valueType = valueType;
        this.units = 0;
        if (svalue != null) {
            Matcher m = DIMENSION_PATTERN.matcher(svalue.trim());
            if (m.matches()) {
                this.value = Float.parseFloat(m.group(1));
                if (m.groupCount() == 2) {
                    String unit = m.group(2);
                    if ("px".equals(unit)) {
                        this.units = 0;
                    } else if ("pt".equals(unit)) {
                        this.units = 3;
                    } else if ("dp".equals(unit) || "dip".equals(unit)) {
                        this.units = 1;
                    } else if ("sp".equals(unit) || "sip".equals(unit)) {
                        this.units = 2;
                    } else if ("%".equals(unit)) {
                        this.units = 17;
                    } else if ("mm".equals(unit)) {
                        this.units = 5;
                    } else if ("in".equals(unit)) {
                        this.units = 4;
                    } else if (DBG && unit != null) {
                        Log.w(LCAT, "Unknown unit: " + unit);
                    }
                }
            } else if (svalue.trim().equals("auto")) {
                this.value = -2.147483648E9;
                this.units = 18;
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Double.valueOf(this.value).intValue();
    }

    public void setValue(double value) {
        this.value = value;
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int units) {
        this.units = units;
    }

    public int getAsPixels(View parent) {
        switch (this.units) {
            case 0: 
            case 16: {
                return (int)this.value;
            }
            case 17: {
                return this.getPercentPixels(parent);
            }
            case 1: 
            case 2: {
                return this.getScaledPixels(parent);
            }
            case 3: 
            case 4: 
            case 5: {
                return this.getSizePixels(parent);
            }
        }
        return -1;
    }

    protected int getPercentPixels(View parent) {
        int dimension = -1;
        switch (this.valueType) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                dimension = parent.getHeight();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                dimension = parent.getWidth();
            }
        }
        if (dimension != -1) {
            return (int)(this.value / 100.0 * (double)dimension);
        }
        return -1;
    }

    protected static DisplayMetrics getDisplayMetrics(View parent) {
        if (metrics == null) {
            WindowManager windowManager = (WindowManager)parent.getContext().getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            metrics = new DisplayMetrics();
            display.getMetrics(metrics);
        }
        return metrics;
    }

    protected int getScaledPixels(View parent) {
        DisplayMetrics metrics = TiDimension.getDisplayMetrics(parent);
        if (this.units == 1) {
            return (int)((double)metrics.density * this.value);
        }
        if (this.units == 2) {
            return (int)((double)metrics.scaledDensity * this.value);
        }
        return -1;
    }

    protected int getSizePixels(View parent) {
        DisplayMetrics metrics = TiDimension.getDisplayMetrics(parent);
        float dpi = -1.0f;
        switch (this.valueType) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                dpi = metrics.ydpi;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                dpi = metrics.xdpi;
            }
        }
        if (this.units == 3) {
            return (int)(this.value * ((double)dpi / 72.0));
        }
        if (this.units == 5) {
            return (int)(this.value / 25.4 * (double)dpi);
        }
        if (this.units == 4) {
            return (int)(this.value * (double)dpi);
        }
        return -1;
    }

    public boolean isUnitUndefined() {
        return this.units == 16;
    }

    public boolean isUnitPercent() {
        return this.units == 17;
    }

    public boolean isUnitAuto() {
        return this.units == 18;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10);
        if (!this.isUnitAuto()) {
            sb.append(this.value);
            switch (this.units) {
                case 0: {
                    sb.append("px");
                    break;
                }
                case 3: {
                    sb.append("pt");
                    break;
                }
                case 1: {
                    sb.append("dp");
                    break;
                }
                case 2: {
                    sb.append("sp");
                    break;
                }
                case 5: {
                    sb.append("mm");
                    break;
                }
                case 4: {
                    sb.append("in");
                    break;
                }
                case 17: {
                    sb.append("%");
                }
            }
        } else {
            sb.append("auto");
        }
        return sb.toString();
    }
}

