/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiStreamHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class TiDeployData {
    private static final String TAG = "TiDeployData";
    protected static final String DEBUGGER_ENABLED = "debuggerEnabled";
    protected static final String DEBUGGER_PORT = "debuggerPort";
    protected static final String FASTDEV_PORT = "fastdevPort";
    protected static final String FASTDEV_LISTEN = "fastdevListen";
    private JSONObject deployData;

    public TiDeployData() {
        TiApplication app = TiApplication.getInstance();
        File extStorage = Environment.getExternalStorageDirectory();
        File deployJson = new File(new File(extStorage, app.getPackageName()), "deploy.json");
        if (deployJson.exists()) {
            this.readDeployData(deployJson);
        }
    }

    protected void readDeployData(File deployJson) {
        try {
            FileInputStream stream = new FileInputStream(deployJson);
            this.deployData = new JSONObject(TiStreamHelper.toString(stream));
            Log.d(TAG, "Read deploy data: " + this.deployData.toString());
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage(), e);
        }
    }

    public boolean isDebuggerEnabled() {
        if (this.deployData == null) {
            return false;
        }
        return this.deployData.optBoolean(DEBUGGER_ENABLED, false);
    }

    public int getDebuggerPort() {
        if (this.deployData == null) {
            return -1;
        }
        return this.deployData.optInt(DEBUGGER_PORT, -1);
    }

    public int getFastDevPort() {
        if (this.deployData == null) {
            return -1;
        }
        return this.deployData.optInt(FASTDEV_PORT, -1);
    }

    public boolean getFastDevListen() {
        if (this.deployData == null) {
            return false;
        }
        return this.deployData.optBoolean(FASTDEV_LISTEN, false);
    }
}

