/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import org.appcelerator.titanium.TiActivity;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.kroll.KrollBridge;
import org.appcelerator.titanium.kroll.KrollContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiJSErrorDialog;
import org.appcelerator.titanium.util.TiUrl;
import org.appcelerator.titanium.util.TiWeakList;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;

public class TiContext
implements ErrorReporter {
    private static final String LCAT = "TiContext";
    private static final boolean DBG = TiConfig.LOGD;
    private static final boolean TRACE = TiConfig.LOGV;
    public static final int LIFECYCLE_ON_START = 0;
    public static final int LIFECYCLE_ON_RESUME = 1;
    public static final int LIFECYCLE_ON_PAUSE = 2;
    public static final int LIFECYCLE_ON_STOP = 3;
    public static final int LIFECYCLE_ON_DESTROY = 4;
    private long mainThreadId = Looper.getMainLooper().getThread().getId();
    private TiUrl baseUrl;
    private String currentUrl;
    private boolean launchContext;
    private boolean serviceContext;
    private WeakReference<Activity> weakActivity;
    private TiApplication tiApp;
    protected KrollContext krollContext;
    protected KrollBridge krollBridge;
    private TiWeakList<OnLifecycleEvent> lifecycleListeners;
    private TiWeakList<OnServiceLifecycleEvent> serviceLifecycleListeners;

    public TiContext(Activity activity, String baseUrl) {
        this.tiApp = activity != null ? (TiApplication)activity.getApplication() : TiApplication.getInstance();
        this.weakActivity = new WeakReference<Activity>(activity);
        this.lifecycleListeners = new TiWeakList(true);
        if (baseUrl == null) {
            baseUrl = "app://";
        } else if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = new TiUrl(baseUrl, null);
        if (activity instanceof TiActivity) {
            ((TiActivity)activity).addTiContext(this);
        }
        if (DBG) {
            Log.e(LCAT, "BaseURL for context is " + baseUrl);
        }
    }

    public boolean isUIThread() {
        return Thread.currentThread().getId() == this.mainThreadId;
    }

    public KrollBridge getKrollBridge() {
        return this.krollBridge;
    }

    public void setKrollBridge(KrollBridge bridge) {
        this.krollBridge = bridge;
    }

    public Activity getActivity() {
        if (this.weakActivity == null) {
            return null;
        }
        Activity activity = (Activity)this.weakActivity.get();
        return activity;
    }

    public void setActivity(Activity activity) {
        if (activity instanceof TiActivity) {
            ((TiActivity)activity).addTiContext(this);
        }
        this.weakActivity = new WeakReference<Activity>(activity);
    }

    public TiApplication getTiApp() {
        return this.tiApp;
    }

    public TiRootActivity getRootActivity() {
        return this.getTiApp().getRootActivity();
    }

    public TiFileHelper getTiFileHelper() {
        return new TiFileHelper((Context)this.getTiApp());
    }

    public String resolveUrl(String path) {
        return this.resolveUrl(null, path);
    }

    public String resolveUrl(String scheme, String path) {
        return this.baseUrl.resolve(this, this.baseUrl.baseUrl, path, scheme);
    }

    public String resolveUrl(String scheme, String path, String relativeTo) {
        return this.baseUrl.resolve(this, relativeTo, path, scheme);
    }

    public String getBaseUrl() {
        return this.baseUrl.baseUrl;
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public Object evalFile(String filename, Messenger messenger, int messageId) throws IOException {
        Object result = null;
        String setUrlBackTo = null;
        if (this.currentUrl != null && this.currentUrl.length() > 0 && !this.currentUrl.equals(filename)) {
            setUrlBackTo = this.currentUrl;
        }
        this.currentUrl = filename;
        if (this.krollBridge == null) {
            if (DBG) {
                Log.w(LCAT, "Cannot eval file '" + filename + "'. Context has been released already.");
            }
            if (setUrlBackTo != null) {
                this.currentUrl = setUrlBackTo;
            }
            return null;
        }
        result = this.krollBridge.evalFile(filename);
        if (messenger != null) {
            try {
                Message msg = Message.obtain();
                msg.what = messageId;
                messenger.send(msg);
                if (DBG) {
                    Log.d(LCAT, "Notifying caller that evalFile has completed");
                }
            }
            catch (RemoteException e) {
                Log.w(LCAT, "Failed to notify caller that eval completed");
            }
        }
        if (setUrlBackTo != null) {
            this.currentUrl = setUrlBackTo;
        }
        return result;
    }

    public Object evalFile(String filename) throws IOException {
        return this.evalFile(filename, null, -1);
    }

    public Object evalJS(String src) {
        if (this.krollBridge == null) {
            Log.e(LCAT, "on evalJS, evaluator is null and shouldn't be");
        }
        return this.krollBridge.evalJS(src);
    }

    public Object evalCommonJsModule(String filename) throws IOException {
        return this.krollBridge.evalCommonJsModule(filename);
    }

    public Scriptable getScope() {
        if (this.krollBridge != null) {
            return this.krollBridge.getScope();
        }
        return null;
    }

    public void addOnLifecycleEventListener(OnLifecycleEvent listener) {
        this.lifecycleListeners.add(new WeakReference<OnLifecycleEvent>(listener));
    }

    public void addOnServiceLifecycleEventListener(OnServiceLifecycleEvent listener) {
        this.serviceLifecycleListeners.add(new WeakReference<OnServiceLifecycleEvent>(listener));
    }

    public void removeOnLifecycleEventListener(OnLifecycleEvent listener) {
        this.lifecycleListeners.remove(listener);
    }

    public void removeOnServiceLifecycleEventListener(OnServiceLifecycleEvent listener) {
        this.serviceLifecycleListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLifecycleEvent(Activity activity, int which) {
        List<WeakReference<OnLifecycleEvent>> list = this.lifecycleListeners.synchronizedList();
        synchronized (list) {
            for (OnLifecycleEvent listener : this.lifecycleListeners.nonNull()) {
                try {
                    this.fireLifecycleEvent(activity, listener, which);
                }
                catch (Throwable t) {
                    Log.e(LCAT, "Error dispatching lifecycle event: " + t.getMessage(), t);
                }
            }
        }
    }

    protected void fireLifecycleEvent(Activity activity, OnLifecycleEvent listener, int which) {
        switch (which) {
            case 0: {
                listener.onStart(activity);
                break;
            }
            case 1: {
                listener.onResume(activity);
                break;
            }
            case 2: {
                listener.onPause(activity);
                break;
            }
            case 3: {
                listener.onStop(activity);
                break;
            }
            case 4: {
                listener.onDestroy(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOnServiceDestroy(Service service) {
        TiWeakList<OnServiceLifecycleEvent> tiWeakList = this.serviceLifecycleListeners;
        synchronized (tiWeakList) {
            for (OnServiceLifecycleEvent listener : this.serviceLifecycleListeners.nonNull()) {
                try {
                    listener.onDestroy(service);
                }
                catch (Throwable t) {
                    Log.e(LCAT, "Error dispatching service onDestroy  event: " + t.getMessage(), t);
                }
            }
        }
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        TiJSErrorDialog.openErrorDialog(this, this.getActivity(), "Error", message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        TiJSErrorDialog.openErrorDialog(this, this.getActivity(), "Runtime Error", message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        TiJSErrorDialog.openErrorDialog(this, this.getActivity(), "Warning", message, sourceName, line, lineSource, lineOffset);
    }

    public static TiContext createTiContext(Activity activity, String baseUrl) {
        return TiContext.createTiContext(activity, baseUrl, null);
    }

    public static TiContext createTiContext(Activity activity, String baseUrl, String loadFile) {
        TiContext tic = new TiContext(activity, baseUrl);
        KrollContext kroll = KrollContext.createContext(tic, loadFile);
        tic.setKrollContext(kroll);
        KrollBridge krollBridge = new KrollBridge(kroll);
        tic.setKrollBridge(krollBridge);
        return tic;
    }

    public KrollContext getKrollContext() {
        return this.krollContext;
    }

    public void setKrollContext(KrollContext krollContext) {
        this.krollContext = krollContext;
    }

    public static TiContext getCurrentTiContext() {
        KrollContext currentCtx = KrollContext.getCurrentKrollContext();
        if (currentCtx == null) {
            return null;
        }
        return currentCtx.getTiContext();
    }

    public void release() {
        if (this.krollBridge != null) {
            this.krollBridge.release();
            this.krollBridge = null;
        }
        if (this.lifecycleListeners != null) {
            this.lifecycleListeners.clear();
        }
        if (this.serviceLifecycleListeners != null) {
            this.serviceLifecycleListeners.clear();
        }
    }

    public boolean isServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(boolean value) {
        this.serviceContext = true;
        if (value && this.serviceLifecycleListeners == null) {
            this.serviceLifecycleListeners = new TiWeakList(true);
        }
    }

    public boolean isLaunchContext() {
        return this.launchContext;
    }

    public void setLaunchContext(boolean launchContext) {
        this.launchContext = launchContext;
    }

    public ContextWrapper getAndroidContext() {
        if (this.weakActivity == null || this.weakActivity.get() == null) {
            return this.tiApp;
        }
        return (ContextWrapper)this.weakActivity.get();
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl.baseUrl = baseUrl;
        if (this.baseUrl.baseUrl == null) {
            this.baseUrl.baseUrl = "app://";
        }
    }

    public static interface OnServiceLifecycleEvent {
        public void onDestroy(Service var1);
    }

    public static interface OnLifecycleEvent {
        public void onStart(Activity var1);

        public void onResume(Activity var1);

        public void onPause(Activity var1);

        public void onStop(Activity var1);

        public void onDestroy(Activity var1);
    }
}

