/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.graphics.Bitmap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiMimeTypeHelper;
import org.appcelerator.titanium.util.TiStreamHelper;

public class TiBlob
extends KrollProxy {
    private static final String LCAT = "TiBlob";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DATA = 2;
    public static final int TYPE_STRING = 3;
    private int type;
    private Object data;
    private String mimetype;
    private int width;
    private int height;

    private TiBlob(TiContext tiContext, int type, Object data, String mimetype) {
        super(tiContext);
        this.type = type;
        this.data = data;
        this.mimetype = mimetype;
        this.width = 0;
        this.height = 0;
    }

    public static TiBlob blobFromString(TiContext tiContext, String data) {
        return new TiBlob(tiContext, 3, data, "text/plain");
    }

    public static TiBlob blobFromFile(TiContext tiContext, TiBaseFile file) {
        return TiBlob.blobFromFile(tiContext, file, TiMimeTypeHelper.getMimeType(file.nativePath()));
    }

    public static TiBlob blobFromFile(TiContext tiContext, TiBaseFile file, String mimeType) {
        if (mimeType == null) {
            mimeType = TiMimeTypeHelper.getMimeType(file.nativePath());
        }
        return new TiBlob(tiContext, 1, file, mimeType);
    }

    public static TiBlob blobFromImage(TiContext tiContext, Bitmap image) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[]{};
        if (image.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos)) {
            data = bos.toByteArray();
        }
        TiBlob blob = new TiBlob(tiContext, 0, data, "image/bitmap");
        blob.width = image.getWidth();
        blob.height = image.getHeight();
        return blob;
    }

    public static TiBlob blobFromData(TiContext tiContext, byte[] data) {
        return TiBlob.blobFromData(tiContext, data, "application/octet-stream");
    }

    public static TiBlob blobFromData(TiContext tiContext, byte[] data, String mimetype) {
        if (mimetype == null || mimetype.length() == 0) {
            return new TiBlob(tiContext, 2, data, "application/octet-stream");
        }
        return new TiBlob(tiContext, 2, data, mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        byte[] bytes = new byte[]{};
        switch (this.type) {
            case 3: {
                try {
                    bytes = ((String)this.data).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.w(LCAT, e.getMessage(), e);
                }
                break;
            }
            case 0: 
            case 2: {
                bytes = (byte[])this.data;
                break;
            }
            case 1: {
                InputStream stream = this.getInputStream();
                if (stream == null) break;
                try {
                    bytes = TiStreamHelper.toByteArray(stream, this.getLength());
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Log.w(LCAT, e.getMessage(), e);
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Log.w(LCAT, e.getMessage(), e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Blob type id " + this.type);
            }
        }
        return bytes;
    }

    public int getLength() {
        switch (this.type) {
            case 1: {
                return (int)((TiBaseFile)this.data).size();
            }
            case 0: 
            case 2: {
                return ((byte[])this.data).length;
            }
        }
        return this.getBytes().length;
    }

    public InputStream getInputStream() {
        switch (this.type) {
            case 1: {
                try {
                    return ((TiBaseFile)this.data).getInputStream();
                }
                catch (IOException e) {
                    Log.e(LCAT, e.getMessage(), e);
                    return null;
                }
            }
        }
        return new ByteArrayInputStream(this.getBytes());
    }

    public void append(TiBlob blob) {
        switch (this.type) {
            case 3: {
                try {
                    String dataString = (String)this.data;
                    dataString = dataString + new String(blob.getBytes(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.w(LCAT, e.getMessage(), e);
                }
                break;
            }
            case 0: 
            case 2: {
                byte[] dataBytes = (byte[])this.data;
                byte[] appendBytes = blob.getBytes();
                byte[] newData = new byte[dataBytes.length + appendBytes.length];
                System.arraycopy(dataBytes, 0, newData, 0, dataBytes.length);
                System.arraycopy(appendBytes, 0, newData, dataBytes.length, appendBytes.length);
                this.data = newData;
                break;
            }
            case 1: {
                throw new IllegalStateException("Not yet implemented. TYPE_FILE");
            }
            default: {
                throw new IllegalArgumentException("Unknown Blob type id " + this.type);
            }
        }
    }

    public String getText() {
        String result = null;
        switch (this.type) {
            case 3: {
                result = (String)this.data;
            }
            case 1: 
            case 2: {
                if (this.mimetype != null && TiMimeTypeHelper.isBinaryMimeType(this.mimetype) && this.mimetype != "application/octet-stream") {
                    return null;
                }
                try {
                    result = new String(this.getBytes(), "utf-8");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    Log.w(LCAT, "Unable to convert to string.");
                }
            }
        }
        return result;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public Object getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public String toString() {
        String text = this.getText();
        if (text != null) {
            return text;
        }
        return "[object TiBlob]";
    }

    public String getNativePath() {
        File f;
        if (this.data == null) {
            return null;
        }
        if (this.type != 1) {
            Log.w(LCAT, "getNativePath not supported for non-file blob types.");
            return null;
        }
        if (!(this.data instanceof TiBaseFile)) {
            Log.w(LCAT, "getNativePath unable to return value: underlying data is not file, rather " + this.data.getClass().getName());
            return null;
        }
        String path = ((TiBaseFile)this.data).nativePath();
        if (path != null && path.startsWith("content://") && (f = ((TiBaseFile)this.data).getNativeFile()) != null && (path = f.getAbsolutePath()) != null && path.startsWith("/")) {
            path = "file://" + path;
        }
        return path;
    }

    public String toBase64() {
        return new String(Base64.encodeBase64((byte[])this.getBytes()));
    }
}

