/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.ServiceProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBindingHelper;
import org.appcelerator.titanium.util.TiConfig;

public class TiBaseService
extends Service {
    public static final String TI_SERVICE_INTENT_ID_KEY = "$__TITANIUM_SERVICE_INTENT_ID__$";
    private static final AtomicInteger serviceIntentIdGenerator = new AtomicInteger();
    private Map<Integer, WeakReference<TiContext>> weakBoundContexts = null;
    private List<WeakReference<TiContext>> weakUnboundContexts = null;
    private static final boolean DBG = TiConfig.LOGD;
    private static final String LCAT = "TiBaseService";
    protected AtomicInteger proxyCounter = new AtomicInteger();

    public IBinder onBind(Intent intent) {
        return new TiServiceBinder();
    }

    public void unregisterBoundTiContext(int serviceIntentId) {
        if (DBG) {
            Log.d(LCAT, "unregisterBoundTiContext " + serviceIntentId);
        }
        if (this.weakBoundContexts == null) {
            if (DBG) {
                Log.d(LCAT, "unregisterBoundTiContext has no weakBoundContexts to work with.  Exiting...");
            }
            return;
        }
        if (!this.weakBoundContexts.containsKey(serviceIntentId)) {
            if (DBG) {
                Log.d(LCAT, "unregisterBoundTiContxt found no weakBoundContext for service intent with id " + serviceIntentId + ". Exiting...");
            }
            return;
        }
        WeakReference<TiContext> context = this.weakBoundContexts.get(serviceIntentId);
        if (context != null) {
            if (DBG) {
                Log.d(LCAT, "Unregistering bound context with service intent id " + serviceIntentId);
            }
            this.unbindContext((TiContext)context.get());
        }
    }

    protected ServiceProxy createProxy(Intent intent) {
        TiContext context = this.createTiContext(intent, null);
        ServiceProxy proxy2 = new ServiceProxy(context, this, intent, this.proxyCounter.incrementAndGet());
        TiBindingHelper.bindCurrentService(context, proxy2);
        return proxy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        TiContext context;
        Object object;
        super.onDestroy();
        if (DBG) {
            Log.d(LCAT, ((Object)((Object)this)).getClass().getSimpleName() + " onDestroy");
        }
        if (this.weakBoundContexts != null) {
            object = this.weakBoundContexts;
            synchronized (object) {
                for (WeakReference<TiContext> weakContext : this.weakBoundContexts.values()) {
                    context = (TiContext)weakContext.get();
                    if (context == null) continue;
                    context.dispatchOnServiceDestroy(this);
                    context.release();
                }
            }
            this.weakBoundContexts.clear();
        }
        this.weakBoundContexts = null;
        if (this.weakUnboundContexts != null) {
            object = this.weakUnboundContexts;
            synchronized (object) {
                for (WeakReference<TiContext> weakContext : this.weakUnboundContexts) {
                    context = (TiContext)weakContext.get();
                    if (context == null) continue;
                    context.dispatchOnServiceDestroy(this);
                    context.release();
                }
            }
            this.weakUnboundContexts.clear();
        }
        this.weakUnboundContexts = null;
    }

    protected TiContext createTiContext(Intent intent, String baseUrl) {
        TiApplication tiApp = (TiApplication)this.getApplication();
        TiContext context = TiContext.createTiContext(tiApp.getRootActivity(), baseUrl);
        context.setServiceContext(true);
        if (this.weakUnboundContexts == null) {
            this.weakUnboundContexts = Collections.synchronizedList(new ArrayList());
        }
        this.weakUnboundContexts.add(new WeakReference<TiContext>(context));
        return context;
    }

    public int registerBoundTiContext(int serviceIntentId, TiContext tiContext) {
        if (this.weakBoundContexts == null) {
            this.weakBoundContexts = Collections.synchronizedMap(new HashMap());
        }
        this.weakBoundContexts.put(serviceIntentId, new WeakReference<TiContext>(tiContext));
        return this.proxyCounter.incrementAndGet();
    }

    public void start(ServiceProxy proxy2) {
    }

    protected void unbindContext(TiContext context) {
    }

    public static int nextServiceBindingIntentId() {
        return serviceIntentIdGenerator.incrementAndGet();
    }

    public class TiServiceBinder
    extends Binder {
        public Service getService() {
            return TiBaseService.this;
        }
    }
}

