/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import java.lang.ref.WeakReference;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiActivityWindows;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.proxy.ActivityProxy;
import org.appcelerator.titanium.proxy.IntentProxy;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiActivitySupportHelper;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiMenuSupport;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.util.TiWeakList;
import org.appcelerator.titanium.view.ITiWindowHandler;
import org.appcelerator.titanium.view.TiCompositeLayout;

public abstract class TiBaseActivity
extends Activity
implements TiActivitySupport,
ITiWindowHandler {
    private static final String TAG = "TiBaseActivity";
    private static final boolean DBG = TiConfig.LOGD;
    private static OrientationChangedListener orientationChangedListener = null;
    private boolean onDestroyFired = false;
    protected TiCompositeLayout layout;
    protected TiActivitySupportHelper supportHelper;
    protected TiWindowProxy window;
    protected ActivityProxy activityProxy;
    protected boolean mustFireInitialFocus;
    protected TiWeakList<ConfigurationChangedListener> configChangedListeners = new TiWeakList();
    protected int orientationDegrees;
    protected TiMenuSupport menuHelper;
    protected TiMessageQueue messageQueue;
    protected Messenger messenger;
    protected int msgActivityCreatedId = -1;
    protected int msgId = -1;

    public static void registerOrientationListener(OrientationChangedListener listener) {
        orientationChangedListener = listener;
    }

    public static void deregisterOrientationListener() {
        orientationChangedListener = null;
    }

    public void activityOnCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public TiApplication getTiApp() {
        return (TiApplication)this.getApplication();
    }

    public TiWindowProxy getWindowProxy() {
        return this.window;
    }

    public void setWindowProxy(TiWindowProxy proxy2) {
        this.window = proxy2;
        this.updateTitle();
    }

    public ActivityProxy getActivityProxy() {
        return this.activityProxy;
    }

    public void setActivityProxy(ActivityProxy proxy2) {
        this.activityProxy = proxy2;
    }

    public TiCompositeLayout getLayout() {
        return this.layout;
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.configChangedListeners.add(new WeakReference<ConfigurationChangedListener>(listener));
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.configChangedListeners.remove(listener);
    }

    public void registerOrientationChangedListener(OrientationChangedListener listener) {
        orientationChangedListener = listener;
    }

    public void deregisterOrientationChangedListener() {
        orientationChangedListener = null;
    }

    protected boolean getIntentBoolean(String property2, boolean defaultValue) {
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(property2)) {
            return intent.getBooleanExtra(property2, defaultValue);
        }
        return defaultValue;
    }

    protected int getIntentInt(String property2, int defaultValue) {
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(property2)) {
            return intent.getIntExtra(property2, defaultValue);
        }
        return defaultValue;
    }

    protected String getIntentString(String property2, String defaultValue) {
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(property2)) {
            return intent.getStringExtra(property2);
        }
        return defaultValue;
    }

    public void fireInitialFocus() {
        if (this.mustFireInitialFocus && this.window != null) {
            this.mustFireInitialFocus = false;
            this.window.fireEvent("focus", null);
        }
    }

    protected void updateTitle() {
        if (this.window == null) {
            return;
        }
        if (this.window.hasProperty("title")) {
            String oldTitle = (String)this.getTitle();
            String newTitle = TiConvert.toString(this.window.getProperty("title"));
            if (oldTitle == null) {
                oldTitle = "";
            }
            if (newTitle == null) {
                newTitle = "";
            }
            if (!newTitle.equals(oldTitle)) {
                final String fnewTitle = newTitle;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TiBaseActivity.this.setTitle(fnewTitle);
                    }
                });
            }
        }
    }

    protected TiCompositeLayout createLayout() {
        TiCompositeLayout.LayoutArrangement arrangement = TiCompositeLayout.LayoutArrangement.DEFAULT;
        String layoutFromIntent = this.getIntentString("layout", "");
        if (layoutFromIntent.equals("horizontal")) {
            arrangement = TiCompositeLayout.LayoutArrangement.HORIZONTAL;
        } else if (layoutFromIntent.equals("vertical")) {
            arrangement = TiCompositeLayout.LayoutArrangement.VERTICAL;
        }
        return new TiCompositeLayout((Context)this, arrangement);
    }

    protected void setFullscreen(boolean fullscreen) {
        if (fullscreen) {
            this.getWindow().setFlags(1024, 1024);
        }
    }

    protected void setNavBarHidden(boolean hidden) {
        if (!hidden) {
            this.requestWindowFeature(3);
            this.requestWindowFeature(4);
            this.requestWindowFeature(2);
            this.requestWindowFeature(5);
        } else {
            this.requestWindowFeature(1);
        }
    }

    protected void windowCreated() {
        boolean useActivityWindow;
        boolean fullscreen = this.getIntentBoolean("fullscreen", false);
        boolean navBarHidden = this.getIntentBoolean("navBarHidden", false);
        boolean modal = this.getIntentBoolean("modal", false);
        int softInputMode = this.getIntentInt("windowSoftInputMode", -1);
        boolean hasSoftInputMode = softInputMode != -1;
        this.setFullscreen(fullscreen);
        this.setNavBarHidden(navBarHidden);
        if (modal) {
            this.getWindow().setFlags(4, 4);
        }
        if (hasSoftInputMode) {
            if (DBG) {
                Log.d(TAG, "windowSoftInputMode: " + softInputMode);
            }
            this.getWindow().setSoftInputMode(softInputMode);
        }
        if (useActivityWindow = this.getIntentBoolean("useActivityWindow", false)) {
            int windowId = this.getIntentInt("windowId", -1);
            TiActivityWindows.windowCreated(this, windowId);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        this.messageQueue = TiMessageQueue.getMessageQueue();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onCreate");
        }
        if ((intent = this.getIntent()) != null && intent.hasExtra("messenger")) {
            this.messenger = (Messenger)intent.getParcelableExtra("messenger");
            this.msgActivityCreatedId = intent.getIntExtra("msgActivityCreatedId", -1);
            this.msgId = intent.getIntExtra("messageId", -1);
        }
        TiPlatformHelper.intializeDisplayMetrics(this);
        this.layout = this.createLayout();
        super.onCreate(savedInstanceState);
        this.getTiApp().setWindowHandler(this);
        this.windowCreated();
        if (this.activityProxy != null) {
            TiApplication tiApp = this.getTiApp();
            Activity tempCurrentActivity = tiApp.getCurrentActivity();
            tiApp.setCurrentActivity(this, this);
            this.activityProxy.fireSyncEvent("create", null);
            tiApp.setCurrentActivity(this, tempCurrentActivity);
        }
        this.setContentView((View)this.layout);
        this.sendMessage(this.msgActivityCreatedId);
        this.sendMessage(this.msgId);
        if (this.window != null) {
            this.window.updateOrientation();
        }
    }

    protected void sendMessage(final int msgId) {
        if (this.messenger == null || msgId == -1) {
            return;
        }
        this.messageQueue.post(new Runnable(){

            @Override
            public void run() {
                TiBaseActivity.this.handleSendMessage(msgId);
            }
        });
    }

    protected void handleSendMessage(int msgId) {
        try {
            Message msg = this.messageQueue.getHandler().obtainMessage(msgId, (Object)this);
            this.messenger.send(msg);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to message creator. finishing.", e);
            this.finish();
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Unable to message creator. finishing.", e);
            this.finish();
        }
    }

    protected TiActivitySupportHelper getSupportHelper() {
        if (this.supportHelper == null) {
            this.supportHelper = new TiActivitySupportHelper(this);
        }
        return this.supportHelper;
    }

    @Override
    public int getUniqueResultCode() {
        return this.getSupportHelper().getUniqueResultCode();
    }

    @Override
    public void launchActivityForResult(Intent intent, int code, TiActivityResultHandler resultHandler) {
        this.getSupportHelper().launchActivityForResult(intent, code, resultHandler);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.getSupportHelper().onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void addWindow(View v, TiCompositeLayout.LayoutParams params) {
        this.layout.addView(v, params);
    }

    @Override
    public void removeWindow(View v) {
        this.layout.removeView(v);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (this.window == null) {
            return super.dispatchKeyEvent(event);
        }
        switch (event.getKeyCode()) {
            case 4: {
                if (!this.window.hasListeners("android:back")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:back", null);
                }
                handled = true;
                break;
            }
            case 27: {
                if (!this.window.hasListeners("android:camera")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:camera", null);
                }
                handled = true;
                break;
            }
            case 80: {
                if (!this.window.hasListeners("android:focus")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:focus", null);
                }
                handled = true;
                break;
            }
            case 84: {
                if (!this.window.hasListeners("android:search")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:search", null);
                }
                handled = true;
                break;
            }
            case 24: {
                if (!this.window.hasListeners("android:volup")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:volup", null);
                }
                handled = true;
                break;
            }
            case 25: {
                if (!this.window.hasListeners("android:voldown")) break;
                if (event.getAction() == 1) {
                    this.window.fireEvent("android:voldown", null);
                }
                handled = true;
            }
        }
        if (!handled) {
            handled = super.dispatchKeyEvent(event);
        }
        return handled;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.menuHelper == null) {
            this.menuHelper = new TiMenuSupport(this.activityProxy);
        }
        return this.menuHelper.onCreateOptionsMenu(super.onCreateOptionsMenu(menu), menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return this.menuHelper.onOptionsItemSelected(item);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        return this.menuHelper.onPrepareOptionsMenu(super.onPrepareOptionsMenu(menu), menu);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        for (WeakReference weakReference : this.configChangedListeners) {
            if (weakReference.get() == null) continue;
            ((ConfigurationChangedListener)weakReference.get()).onConfigurationChanged(this, newConfig);
        }
        if (orientationChangedListener != null) {
            orientationChangedListener.onOrientationChanged(newConfig.orientation);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onNewIntent");
        }
        if (this.activityProxy != null) {
            IntentProxy ip = new IntentProxy(this.activityProxy.getTiContext(), intent);
            KrollDict data = new KrollDict();
            data.put("intent", ip);
            this.activityProxy.fireSyncEvent("newIntent", data);
        }
    }

    protected void onPause() {
        super.onPause();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onPause");
        }
        this.getTiApp().setWindowHandler(null);
        this.getTiApp().setCurrentActivity(this, null);
        if (this.activityProxy != null) {
            this.activityProxy.fireSyncEvent("pause", null);
        }
    }

    protected void onResume() {
        super.onResume();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onResume");
        }
        this.getTiApp().setWindowHandler(this);
        this.getTiApp().setCurrentActivity(this, this);
        if (this.activityProxy != null) {
            this.activityProxy.fireSyncEvent("resume", null);
        }
    }

    protected void onStart() {
        super.onStart();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onStart");
        }
        this.updateTitle();
        if (this.window != null) {
            this.window.fireEvent("focus", null);
        } else {
            this.mustFireInitialFocus = true;
        }
        if (this.activityProxy != null) {
            TiApplication tiApp = this.getTiApp();
            Activity tempCurrentActivity = tiApp.getCurrentActivity();
            tiApp.setCurrentActivity(this, this);
            this.activityProxy.fireSyncEvent("start", null);
            tiApp.setCurrentActivity(this, tempCurrentActivity);
        }
    }

    protected void onStop() {
        super.onStop();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onStop");
        }
        if (this.window != null) {
            this.window.fireEvent("blur", null);
        }
        if (this.activityProxy != null) {
            this.activityProxy.fireSyncEvent("stop", null);
        }
    }

    protected void onRestart() {
        super.onRestart();
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onRestart");
        }
        if (this.activityProxy != null) {
            TiApplication tiApp = this.getTiApp();
            Activity tempCurrentActivity = tiApp.getCurrentActivity();
            tiApp.setCurrentActivity(this, this);
            this.activityProxy.fireSyncEvent("restart", null);
            tiApp.setCurrentActivity(this, tempCurrentActivity);
        }
    }

    protected void onDestroy() {
        if (DBG) {
            Log.d(TAG, "Activity " + this + " onDestroy");
        }
        super.onDestroy();
        if (!this.isFinishing()) {
            if (!this.shouldFinishRootActivity()) {
                this.getIntent().putExtra("finishRoot", true);
            }
            this.getTiApp().scheduleRestart(250);
            this.finish();
            return;
        }
        this.fireOnDestroy();
        if (this.layout != null) {
            Log.e(TAG, "Layout cleanup.");
            this.layout.removeAllViews();
            this.layout = null;
        }
        if (this.window != null) {
            this.window.closeFromActivity();
            this.window = null;
        }
        if (this.menuHelper != null) {
            this.menuHelper.destroy();
            this.menuHelper = null;
        }
        if (this.activityProxy != null) {
            this.activityProxy.release();
            this.activityProxy = null;
        }
    }

    protected void fireOnDestroy() {
        if (!this.onDestroyFired) {
            if (this.activityProxy != null) {
                this.activityProxy.fireSyncEvent("destroy", null);
            }
            this.onDestroyFired = true;
        }
    }

    protected boolean shouldFinishRootActivity() {
        return this.getIntentBoolean("finishRoot", false);
    }

    public void finish() {
        TiRootActivity rootActivity;
        TiApplication app;
        if (this.window != null) {
            KrollDict data = new KrollDict();
            data.put("source", this.window);
            this.window.fireSyncEvent("close", data);
        }
        boolean animate = this.getIntentBoolean("animate", true);
        if (this.shouldFinishRootActivity() && (app = this.getTiApp()) != null && (rootActivity = app.getRootActivity()) != null && !rootActivity.equals(this)) {
            rootActivity.finish();
        }
        super.finish();
        if (!animate) {
            TiUIHelper.overridePendingTransition(this);
        }
    }

    public static interface ConfigurationChangedListener {
        public void onConfigurationChanged(TiBaseActivity var1, Configuration var2);
    }

    public static interface OrientationChangedListener {
        public void onOrientationChanged(int var1);
    }
}

