/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.util.DisplayMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollModuleInfo;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.ITiAppInfo;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDeployData;
import org.appcelerator.titanium.TiProperties;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.TiScriptRunner;
import org.appcelerator.titanium.TiStylesheet;
import org.appcelerator.titanium.analytics.TiAnalyticsEvent;
import org.appcelerator.titanium.analytics.TiAnalyticsEventFactory;
import org.appcelerator.titanium.analytics.TiAnalyticsModel;
import org.appcelerator.titanium.analytics.TiAnalyticsService;
import org.appcelerator.titanium.kroll.KrollBridge;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiResponseCache;
import org.appcelerator.titanium.util.TiTempFileHelper;
import org.appcelerator.titanium.view.ITiWindowHandler;

public abstract class TiApplication
extends Application {
    public static final String DEPLOY_TYPE_DEVELOPMENT = "development";
    public static final String DEPLOY_TYPE_TEST = "test";
    public static final String DEPLOY_TYPE_PRODUCTION = "production";
    public static final int DEFAULT_THREAD_STACK_SIZE = 16384;
    public static final String APPLICATION_PREFERENCES_NAME = "titanium";
    private static final String PROPERTY_DEPLOY_TYPE = "ti.deploytype";
    private static final String PROPERTY_THREAD_STACK_SIZE = "ti.android.threadstacksize";
    private static final String PROPERTY_COMPILE_JS = "ti.android.compilejs";
    public static final String PROPERTY_FASTDEV = "ti.android.fastdev";
    private static final String LCAT = "TiApplication";
    private static final boolean DBG = TiConfig.LOGD;
    private static final long STATS_WAIT = 300000L;
    protected static TiApplication _instance = null;
    private String baseUrl;
    private String startUrl;
    private HashMap<Class<?>, HashMap<String, Method>> methodMap;
    private HashMap<String, SoftReference<KrollProxy>> proxyMap;
    private TiRootActivity rootActivity;
    private TiProperties appProperties;
    private TiProperties systemProperties;
    private ITiWindowHandler windowHandler;
    private Activity currentActivity;
    protected ITiAppInfo appInfo;
    protected TiStylesheet stylesheet;
    private String density;
    private boolean needsStartEvent;
    private boolean needsEnrollEvent;
    protected TiAnalyticsModel analyticsModel;
    protected Intent analyticsIntent;
    private static long lastAnalyticsTriggered = 0L;
    private String buildVersion = "";
    private String buildTimestamp = "";
    private String buildHash = "";
    protected ArrayList<KrollModule> modules = new ArrayList();
    protected TiDeployData deployData;
    protected TiTempFileHelper tempFileHelper;
    private ArrayList<KrollProxy> appEventProxies = new ArrayList();

    public TiApplication() {
        Log.checkpoint(LCAT, "checkpoint, app created.");
        _instance = this;
        this.needsEnrollEvent = false;
        this.needsStartEvent = true;
        this.loadBuildProperties();
        Log.i(LCAT, "Titanium " + this.buildVersion + " (" + this.buildTimestamp + " " + this.buildHash + ")");
    }

    public void bindModules(KrollBridge bridge, KrollProxy parent) {
        if (this.modules.isEmpty()) {
            this.bootModules(bridge.getKrollContext().getTiContext());
            for (KrollModule module2 : this.modules) {
                module2.bindToParent(parent);
            }
        }
        for (KrollModule module2 : this.modules) {
            module2.bindContextSpecific(bridge);
        }
    }

    protected abstract void bootModules(TiContext var1);

    public KrollModule requireModule(TiContext context, KrollModuleInfo info) {
        return this.getModuleById(info.getId());
    }

    public List<KrollModule> getModules() {
        return this.modules;
    }

    public KrollModule getModuleById(String id) {
        for (KrollModule module2 : this.modules) {
            if (!module2.getId().equals(id)) continue;
            return module2;
        }
        return null;
    }

    public <T extends KrollModule> T getModuleByClass(Class<T> moduleClass) {
        for (KrollModule module2 : this.modules) {
            if (!module2.getClass().equals(moduleClass)) continue;
            return (T)module2;
        }
        return null;
    }

    public void releaseModules() {
        this.modules.clear();
    }

    public String[] getFilteredBindings(String moduleName) {
        return null;
    }

    public static TiApplication getInstance() {
        return _instance;
    }

    protected void loadBuildProperties() {
        this.buildVersion = "1.0";
        this.buildTimestamp = "N/A";
        this.buildHash = "N/A";
        InputStream versionStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/appcelerator/titanium/build.properties");
        if (versionStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(versionStream);
                if (properties.containsKey("build.version")) {
                    this.buildVersion = properties.getProperty("build.version");
                }
                if (properties.containsKey("build.timestamp")) {
                    this.buildTimestamp = properties.getProperty("build.timestamp");
                }
                if (properties.containsKey("build.githash")) {
                    this.buildHash = properties.getProperty("build.githash");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void onCreate() {
        super.onCreate();
        TiScriptRunner.getInstance().setAppPackageName(this.getPackageName());
        if (DBG) {
            Log.d(LCAT, "Application onCreate");
        }
        final Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                String tiVer = TiApplication.this.buildVersion + "," + TiApplication.this.buildTimestamp + "," + TiApplication.this.buildHash;
                Log.e("TiUncaughtHandler", "Sending event: exception on thread: " + t.getName() + " msg:" + e.toString() + "; Titanium " + tiVer, e);
                TiApplication.this.postAnalyticsEvent(TiAnalyticsEventFactory.createErrorEvent(t, e, tiVer));
                defaultHandler.uncaughtException(t, e);
            }
        });
        this.baseUrl = "file:///android_asset/Resources/";
        File fullPath = new File(this.baseUrl, this.getStartFilename("app.js"));
        this.baseUrl = fullPath.getParent();
        this.methodMap = new HashMap(25);
        this.proxyMap = new HashMap(5);
        this.appProperties = new TiProperties(this.getApplicationContext(), APPLICATION_PREFERENCES_NAME, false);
        this.systemProperties = new TiProperties(this.getApplicationContext(), "system", true);
        if (this.getDeployType().equals(DEPLOY_TYPE_DEVELOPMENT)) {
            this.deployData = new TiDeployData();
        }
        this.tempFileHelper = new TiTempFileHelper(this);
    }

    public void postAppInfo() {
        TiPlatformHelper.initialize();
    }

    public void postOnCreate() {
        TiConfig.LOGD = this.systemProperties.getBool("ti.android.debug", false);
        File cacheDir = new File(new TiFileHelper((Context)this).getDataDirectory(false), "remote-image-cache");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        TiResponseCache.setDefault(new TiResponseCache(cacheDir.getAbsoluteFile(), this));
    }

    public void setRootActivity(TiRootActivity rootActivity) {
        this.rootActivity = rootActivity;
        this.windowHandler = rootActivity;
        DisplayMetrics dm = new DisplayMetrics();
        rootActivity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        switch (dm.densityDpi) {
            case 240: {
                this.density = "high";
                break;
            }
            case 160: {
                this.density = "medium";
                break;
            }
            case 120: {
                this.density = "low";
            }
        }
        if (this.collectAnalytics()) {
            String deployType;
            this.analyticsIntent = new Intent((Context)this, TiAnalyticsService.class);
            this.analyticsModel = new TiAnalyticsModel((Context)this);
            this.needsEnrollEvent = this.analyticsModel.needsEnrollEvent();
            if (this.needsEnrollEvent()) {
                deployType = this.systemProperties.getString(PROPERTY_DEPLOY_TYPE, "unknown");
                this.postAnalyticsEvent(TiAnalyticsEventFactory.createAppEnrollEvent(this, deployType));
            }
            if (this.needsStartEvent()) {
                deployType = this.systemProperties.getString(PROPERTY_DEPLOY_TYPE, "unknown");
                this.postAnalyticsEvent(TiAnalyticsEventFactory.createAppStartEvent(this, deployType));
            }
        } else {
            this.needsEnrollEvent = false;
            this.needsStartEvent = false;
            Log.i(LCAT, "Analytics have been disabled");
        }
        this.tempFileHelper.scheduleCleanTempDir();
    }

    public TiRootActivity getRootActivity() {
        return this.rootActivity;
    }

    public ITiWindowHandler getWindowHandler() {
        return this.windowHandler;
    }

    public Activity getCurrentActivity() {
        return this.currentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentActivity(Activity callingActivity, Activity newValue) {
        TiApplication tiApplication = this;
        synchronized (tiApplication) {
            if (this.currentActivity == null || callingActivity == this.currentActivity && newValue == null) {
                this.currentActivity = newValue;
            }
        }
    }

    public void setWindowHandler(ITiWindowHandler windowHandler) {
        this.windowHandler = windowHandler == null ? this.rootActivity : windowHandler;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getStartUrl() {
        return this.startUrl;
    }

    private String getStartFilename(String defaultStartFile) {
        return defaultStartFile;
    }

    public synchronized Method methodFor(Class<?> source, String name) {
        HashMap<String, Method> classMethods = this.methodMap.get(source);
        if (classMethods == null) {
            Method[] methods = source.getMethods();
            classMethods = new HashMap(methods.length);
            this.methodMap.put(source, classMethods);
            final HashMap hierarchy = new HashMap();
            int i = 0;
            hierarchy.put(source, 0);
            for (Class<?> superClass = source.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                hierarchy.put(superClass, ++i);
            }
            Comparator<Method> comparator = new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    int h1 = (Integer)hierarchy.get(o1.getDeclaringClass());
                    int h2 = (Integer)hierarchy.get(o2.getDeclaringClass());
                    return h1 - h2;
                }
            };
            List<Method> methodList = Arrays.asList(methods);
            Collections.sort(methodList, comparator);
            Collections.reverse(methodList);
            for (Method method2 : methodList) {
                classMethods.put(method2.getName(), method2);
            }
        }
        return classMethods.get(name);
    }

    public void addAppEventProxy(KrollProxy appEventProxy) {
        Log.e(LCAT, "APP PROXY: " + appEventProxy);
        if (appEventProxy != null && !this.appEventProxies.contains(appEventProxy)) {
            this.appEventProxies.add(appEventProxy);
        }
    }

    public void removeAppEventProxy(KrollProxy appEventProxy) {
        this.appEventProxies.remove(appEventProxy);
    }

    public boolean fireAppEvent(KrollInvocation invocation, String eventName, KrollDict data) {
        boolean handled = false;
        for (KrollProxy appEventProxy : this.appEventProxies) {
            boolean proxyHandled = appEventProxy.fireEvent(eventName, data);
            handled = handled || proxyHandled;
        }
        return handled;
    }

    public TiProperties getAppProperties() {
        return this.appProperties;
    }

    public TiProperties getSystemProperties() {
        return this.systemProperties;
    }

    public ITiAppInfo getAppInfo() {
        return this.appInfo;
    }

    public KrollDict getStylesheet(String basename, Collection<String> classes, String objectId) {
        if (this.stylesheet != null) {
            return this.stylesheet.getStylesheet(objectId, classes, this.density, basename);
        }
        return new KrollDict();
    }

    public void registerProxy(KrollProxy proxy2) {
        String proxyId = proxy2.getProxyId();
        if (!this.proxyMap.containsKey(proxyId)) {
            this.proxyMap.put(proxyId, new SoftReference<KrollProxy>(proxy2));
        }
    }

    public KrollProxy unregisterProxy(String proxyId) {
        KrollProxy proxy2 = null;
        SoftReference<KrollProxy> ref = this.proxyMap.remove(proxyId);
        if (ref != null) {
            proxy2 = ref.get();
        }
        return proxy2;
    }

    public void onLowMemory() {
        super.onLowMemory();
    }

    public void onTerminate() {
        super.onTerminate();
    }

    public synchronized boolean needsStartEvent() {
        return this.needsStartEvent;
    }

    public synchronized boolean needsEnrollEvent() {
        return this.needsEnrollEvent;
    }

    private boolean collectAnalytics() {
        return this.getAppInfo().isAnalyticsEnabled();
    }

    public synchronized void postAnalyticsEvent(TiAnalyticsEvent event) {
        if (!this.collectAnalytics()) {
            if (DBG) {
                Log.i(LCAT, "Analytics are disabled, ignoring postAnalyticsEvent");
            }
            return;
        }
        if (DBG) {
            StringBuilder sb = new StringBuilder();
            sb.append("Analytics Event: type=").append(event.getEventType()).append("\n event=").append(event.getEventEvent()).append("\n timestamp=").append(event.getEventTimestamp()).append("\n mid=").append(event.getEventMid()).append("\n sid=").append(event.getEventSid()).append("\n aguid=").append(event.getEventAppGuid()).append("\n isJSON=").append(event.mustExpandPayload()).append("\n payload=").append(event.getEventPayload());
            Log.d(LCAT, sb.toString());
        }
        if (event.getEventType() == "ti.enroll") {
            if (this.needsEnrollEvent) {
                this.analyticsModel.addEvent(event);
                this.needsEnrollEvent = false;
                this.sendAnalytics();
                this.analyticsModel.markEnrolled();
            }
        } else {
            if (event.getEventType() == "ti.start") {
                if (this.needsStartEvent) {
                    this.analyticsModel.addEvent(event);
                    this.needsStartEvent = false;
                    this.sendAnalytics();
                    lastAnalyticsTriggered = System.currentTimeMillis();
                }
                return;
            }
            if (event.getEventType() == "ti.end") {
                this.needsStartEvent = true;
                this.analyticsModel.addEvent(event);
                this.sendAnalytics();
            } else {
                this.analyticsModel.addEvent(event);
                long now = System.currentTimeMillis();
                if (now - lastAnalyticsTriggered >= 300000L) {
                    this.sendAnalytics();
                    lastAnalyticsTriggered = now;
                }
            }
        }
    }

    public void sendAnalytics() {
        if (this.analyticsIntent != null && this.startService(this.analyticsIntent) == null) {
            Log.w(LCAT, "Analytics service not found.");
        }
    }

    public String getDeployType() {
        return this.getSystemProperties().getString(PROPERTY_DEPLOY_TYPE, DEPLOY_TYPE_DEVELOPMENT);
    }

    public String getTiBuildVersion() {
        return this.buildVersion;
    }

    public String getTiBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getTiBuildHash() {
        return this.buildHash;
    }

    public int getThreadStackSize() {
        return this.getSystemProperties().getInt(PROPERTY_THREAD_STACK_SIZE, 16384);
    }

    public boolean forceCompileJS() {
        return this.getSystemProperties().getBool(PROPERTY_COMPILE_JS, false);
    }

    public TiDeployData getDeployData() {
        return this.deployData;
    }

    public boolean isFastDevMode() {
        return this.getSystemProperties().getBool(PROPERTY_FASTDEV, this.getDeployType().equals(DEPLOY_TYPE_DEVELOPMENT));
    }

    public void scheduleRestart(int delay) {
        Log.w(LCAT, "Scheduling application restart");
        if (DBG) {
            Log.d(LCAT, "Here is call stack leading to restart. (NOTE: this is not a real exception, just a stack trace.) :");
            new Exception().printStackTrace();
        }
        if (this.getRootActivity() != null) {
            this.getRootActivity().restartActivity(delay);
        }
    }

    public TiTempFileHelper getTempFileHelper() {
        return this.tempFileHelper;
    }
}

