/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium;

import java.lang.ref.WeakReference;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.TiWeakList;

public class TiActivity
extends TiBaseActivity {
    protected TiWeakList<TiContext> contexts = new TiWeakList();

    public void addTiContext(TiContext context) {
        if (!this.contexts.contains(context)) {
            this.contexts.add(new WeakReference<TiContext>(context));
        }
    }

    public void removeTiContext(TiContext context) {
        if (this.contexts.contains(context)) {
            this.contexts.remove(context);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        for (TiContext context : this.contexts.nonNull()) {
            context.fireLifecycleEvent(this, 2);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        for (TiContext context : this.contexts.nonNull()) {
            context.fireLifecycleEvent(this, 1);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        for (TiContext context : this.contexts.nonNull()) {
            context.fireLifecycleEvent(this, 0);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        for (TiContext context : this.contexts.nonNull()) {
            context.fireLifecycleEvent(this, 3);
        }
    }

    @Override
    protected void onDestroy() {
        this.fireOnDestroy();
        for (TiContext context : this.contexts.nonNull()) {
            context.fireLifecycleEvent(this, 4);
            context.release();
        }
        super.onDestroy();
    }
}

