/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll.util;

import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDefaultValueProvider;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollJavascriptConverter;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;

public class KrollBindingUtils {
    public static void assertRequiredArgs(Object[] methodArgs, int requiredArgs, String methodName) throws IllegalArgumentException {
        if (methodArgs == null) {
            throw new IllegalArgumentException(String.format("Expected %d arguments for %s, got 0", requiredArgs, methodName));
        }
        if (methodArgs.length < requiredArgs) {
            throw new IllegalArgumentException(String.format("Expected %d arguments for %s, got %d", requiredArgs, methodName, methodArgs.length));
        }
    }

    public static Object[] getVarArgs(KrollInvocation invocation, Object[] methodArgs, int argIndex, KrollJavascriptConverter argConverter, KrollDefaultValueProvider defaultValueProvider) {
        int methodArgsLen = methodArgs.length;
        Object[] varArgs = new Object[methodArgsLen - argIndex];
        if (methodArgsLen == argIndex + 1) {
            Object firstValue = argConverter.convertJavascript(invocation, methodArgs[argIndex], Object.class);
            if (firstValue instanceof Object[]) {
                varArgs = (Object[])firstValue;
            } else {
                varArgs[0] = firstValue;
            }
        } else if (methodArgsLen == argIndex) {
            varArgs = (Object[])defaultValueProvider.getDefaultValue(Object[].class);
        } else {
            for (int i = argIndex; i < methodArgsLen; ++i) {
                varArgs[i - argIndex] = argConverter.convertJavascript(invocation, methodArgs[i], Object.class);
            }
        }
        return varArgs;
    }

    public static KrollMethod createCreateMethod(String methodName, final KrollProxyCreator creator) {
        return new KrollMethod(methodName){

            @Override
            public Object invoke(KrollInvocation invocation, Object[] args) throws Exception {
                KrollProxy proxy2 = creator.create(invocation.getTiContext());
                return proxy2.handleCreate(invocation, args);
            }
        };
    }

    public static KrollMethod createAccessorMethod(final String accessor, final boolean isSet) {
        return new KrollMethod(accessor){

            @Override
            public Object invoke(KrollInvocation invocation, Object[] args) throws Exception {
                if (!isSet) {
                    return KrollConverter.getInstance().convertNative(invocation, invocation.getProxy().getProperty(accessor));
                }
                invocation.getProxy().setProperty(accessor, args.length > 0 ? KrollConverter.getInstance().convertJavascript(invocation, args[0], Object.class) : null, true);
                return KrollProxy.UNDEFINED;
            }
        };
    }

    public static interface KrollProxyCreator {
        public KrollProxy create(TiContext var1);
    }
}

