/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.appcelerator.kroll.KrollConvertable;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.mozilla.javascript.Scriptable;

public class KrollScriptableDict
extends KrollDict
implements KrollConvertable {
    protected Scriptable scriptable;

    public KrollScriptableDict(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    public Scriptable getScriptable() {
        return this.scriptable;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (key instanceof Integer) {
            return this.scriptable.has(((Integer)key).intValue(), this.scriptable);
        }
        if (!this.scriptable.has(key.toString(), this.scriptable)) {
            try {
                Integer i = Integer.valueOf(key.toString());
                return this.scriptable.has(i.intValue(), this.scriptable);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object key : this.scriptable.getIds()) {
            Object v = this.get(key);
            if (v != null && v.equals(value)) {
                return true;
            }
            if (v != null || value != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (Object key : this.scriptable.getIds()) {
            if (key instanceof Number) {
                this.scriptable.delete(((Number)key).intValue());
                continue;
            }
            this.scriptable.delete(key.toString());
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        TreeSet<Map.Entry<String, Object>> entries = new TreeSet<Map.Entry<String, Object>>();
        for (Object key : this.scriptable.getIds()) {
            entries.add(new Entry(key.toString(), this.get(key)));
        }
        return entries;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.scriptable.get(key.toString(), this.scriptable);
        if (value == Scriptable.NOT_FOUND) {
            try {
                Integer i = Integer.valueOf(key.toString());
                value = this.scriptable.get(i.intValue(), this.scriptable);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (value == Scriptable.NOT_FOUND) {
                return null;
            }
        }
        KrollInvocation invocation = KrollInvocation.createPropertyGetInvocation(this.scriptable, this.scriptable, key.toString(), null, null);
        Object result = KrollConverter.getInstance().convertJavascript(invocation, value, Object.class);
        invocation.recycle();
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.scriptable.getIds().length == 0;
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> keys = new TreeSet<String>();
        for (Object key : this.scriptable.getIds()) {
            keys.add(key.toString());
        }
        return keys;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            return null;
        }
        KrollInvocation invocation = KrollInvocation.createPropertySetInvocation(this.scriptable, this.scriptable, key, null, null);
        value = KrollConverter.getInstance().convertNative(invocation, value);
        this.scriptable.put(key.toString(), this.scriptable, value);
        invocation.recycle();
        return value;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.get(key.toString());
        this.scriptable.delete(key.toString());
        return value;
    }

    @Override
    public int size() {
        return this.scriptable.getIds().length;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object key : this.scriptable.getIds()) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public Object getJavascriptValue() {
        return this.getScriptable();
    }

    @Override
    public Object getNativeValue() {
        return this;
    }

    protected class Entry
    implements Map.Entry<String, Object>,
    Comparable<Entry> {
        protected String key;
        protected Object value;

        public Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            return KrollScriptableDict.this.put(this.key, value);
        }

        @Override
        public int compareTo(Entry other) {
            return other.key.compareTo(this.key);
        }
    }
}

