/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import java.lang.reflect.Field;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollJavascriptConverter;
import org.appcelerator.kroll.KrollNativeConverter;
import org.appcelerator.kroll.KrollProperty;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.util.KrollReflectionUtils;

public class KrollReflectionProperty
implements KrollProperty {
    protected String name;
    protected boolean get;
    protected boolean set;
    protected String fieldName;
    protected KrollNativeConverter nativeConverter;
    protected KrollJavascriptConverter javascriptConverter;

    public KrollReflectionProperty(String name, boolean get, boolean set, String fieldName) {
        this.name = name;
        this.get = get;
        this.set = set;
        this.fieldName = fieldName;
    }

    @Override
    public Object get(KrollInvocation invocation, String name) {
        if (!this.supportsGet(name)) {
            return KrollProxy.UNDEFINED;
        }
        if (invocation.getProxy() != null) {
            KrollProxy proxy2 = invocation.getProxy();
            Field field = KrollReflectionUtils.getField(proxy2.getClass(), this.fieldName);
            try {
                return this.nativeConverter.convertNative(invocation, field.get(proxy2));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return KrollProxy.UNDEFINED;
    }

    @Override
    public void set(KrollInvocation invocation, String name, Object value) {
        if (!this.supportsSet(name)) {
            return;
        }
        if (invocation.getProxy() != null) {
            KrollProxy proxy2 = invocation.getProxy();
            Field field = KrollReflectionUtils.getField(proxy2.getClass(), this.fieldName);
            try {
                field.set(proxy2, this.javascriptConverter.convertJavascript(invocation, value, Object.class));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean supportsGet(String name) {
        return this.get && name.equals(this.name);
    }

    @Override
    public boolean supportsSet(String name) {
        return this.set && name.equals(this.name);
    }

    public void setNativeConverter(KrollNativeConverter nativeConverter) {
        this.nativeConverter = nativeConverter;
    }

    public void setJavascriptConverter(KrollJavascriptConverter javascriptConverter) {
        this.javascriptConverter = javascriptConverter;
    }
}

