/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollConvertable;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollEventManager;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProperty;
import org.appcelerator.kroll.KrollPropertyChange;
import org.appcelerator.kroll.KrollProxyBinding;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.kroll.KrollBridge;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class KrollProxy
implements Handler.Callback,
OnEventListenerChange,
KrollConvertable {
    private static final String TAG = "KrollProxy";
    private static final boolean DBG = TiConfig.LOGD;
    protected static final int MSG_MODEL_PROPERTY_CHANGE = 100;
    protected static final int MSG_LISTENER_ADDED = 101;
    protected static final int MSG_LISTENER_REMOVED = 102;
    protected static final int MSG_MODEL_PROPERTIES_CHANGED = 103;
    protected static final int MSG_LAST_ID = 999;
    protected static AtomicInteger proxyCounter = new AtomicInteger();
    protected static HashMap<Class<? extends KrollProxy>, KrollProxyBinding> proxyBindings = new HashMap();
    public static final String PROXY_ID_PREFIX = "proxy$";
    public static final String BINDING_SUFFIX = "BindingGen";
    public static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };
    protected KrollDict properties = new KrollDict();
    protected TiContext context;
    protected TiContext creatingContext;
    protected Handler uiHandler;
    protected String proxyId;
    protected KrollProxyListener modelListener;
    protected KrollEventManager eventManager;
    protected KrollModule createdInModule;
    protected KrollProxyBinding binding;
    protected KrollObject krollObject;
    protected KrollInvocation currentInvocation;
    protected KrollDict creationDict = null;

    public KrollProxy(TiContext context) {
        this(context, true);
    }

    public KrollProxy(TiContext context, boolean autoBind) {
        Activity activity;
        this.context = context;
        this.eventManager = new KrollEventManager(this);
        if (DBG) {
            Log.d(TAG, "New: " + this.getClass().getSimpleName());
        }
        this.proxyId = PROXY_ID_PREFIX + proxyCounter.incrementAndGet();
        this.uiHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        if (!(context.isUIThread() || (activity = context.getActivity()) != null && !activity.isFinishing() || context.isServiceContext())) {
            if (DBG) {
                Log.w(TAG, "Proxy created in context with no activity and no service.  Activity finished?  Context is effectively dead.");
            }
            return;
        }
    }

    public static KrollProxyBinding getBinding(Class<? extends KrollProxy> proxyClass) {
        if (!proxyBindings.containsKey(proxyClass)) {
            String bindingClassName = proxyClass.getName() + BINDING_SUFFIX;
            try {
                Class<?> bindingClass = Class.forName(bindingClassName);
                KrollProxyBinding bindingInstance = (KrollProxyBinding)bindingClass.newInstance();
                proxyBindings.put(proxyClass, bindingInstance);
                return bindingInstance;
            }
            catch (ClassNotFoundException e) {
                Log.e(TAG, "Couldn't find binding class for proxy " + proxyClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                Log.e(TAG, "Couldn't access constructor for binding class " + bindingClassName, e);
            }
            catch (InstantiationException e) {
                Log.e(TAG, "Couldn't insantiate binding class " + bindingClassName, e);
            }
        }
        return proxyBindings.get(proxyClass);
    }

    public KrollProxyBinding getBinding() {
        if (this.binding == null) {
            this.binding = KrollProxy.getBinding(this.getClass());
        }
        return this.binding;
    }

    public boolean hasBinding(String name) {
        return this.getBinding().hasBinding(name);
    }

    public Object getBinding(String name) {
        return this.getBinding().getBinding(name);
    }

    public void bindContextSpecific(KrollBridge bridge) {
        KrollProxyBinding binding = this.getBinding();
        binding.bindContextSpecific(bridge, this);
    }

    public String getAPIName() {
        return this.getBinding().getAPIName();
    }

    public String getShortAPIName() {
        return this.getBinding().getShortAPIName();
    }

    public KrollObject getKrollObject() {
        if (this.krollObject == null) {
            this.krollObject = new KrollObject(this);
        }
        return this.krollObject;
    }

    public boolean has(Scriptable scope, String name) {
        return this.hasBinding(name) || this.properties.containsKey(name);
    }

    public boolean has(Scriptable scope, int index) {
        return false;
    }

    public Object get(Scriptable scope, String name) throws NoSuchFieldException {
        if (this.hasBinding(name)) {
            Object value = this.getBinding(name);
            if (value instanceof KrollProperty) {
                KrollProperty property2 = (KrollProperty)value;
                if (property2.supportsGet(name)) {
                    return this.getDynamicProperty(scope, name, property2);
                }
            } else {
                return value;
            }
        }
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return UNDEFINED;
    }

    public Object get(Scriptable scope, int index) {
        return UNDEFINED;
    }

    public void set(Scriptable scope, String name, Object value) throws NoSuchFieldException {
        KrollProperty property2;
        Object currentValue;
        if (this.hasBinding(name) && (currentValue = this.getBinding(name)) instanceof KrollProperty && (property2 = (KrollProperty)currentValue).supportsSet(name)) {
            this.setDynamicProperty(scope, name, property2, value);
            return;
        }
        this.setProperty(name, value, true);
    }

    public void set(Scriptable scope, int index, Object value) {
    }

    public Object call(Scriptable scope, String name, Object[] args) throws Exception {
        Object value = UNDEFINED;
        try {
            value = this.get(scope, name);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (value != UNDEFINED && value instanceof KrollMethod) {
            KrollMethod method2 = (KrollMethod)((Object)value);
            KrollInvocation inv = KrollInvocation.createMethodInvocation(TiContext.getCurrentTiContext(), scope, (Scriptable)this.getKrollObject(), name, method2, this);
            Object result = method2.invoke(inv, args);
            inv.recycle();
            return result;
        }
        throw new NoSuchMethodException("method \"" + name + "\" of proxy \"" + this.getAPIName() + "\" wasn't found");
    }

    protected Object getDynamicProperty(Scriptable scope, String name, KrollProperty dynprop) throws NoSuchFieldException {
        if (dynprop.supportsGet(name)) {
            KrollInvocation inv = KrollInvocation.createPropertyGetInvocation(TiContext.getCurrentTiContext(), scope, (Scriptable)this.getKrollObject(), name, dynprop, this);
            Object result = dynprop.get(inv, name);
            inv.recycle();
            return result;
        }
        throw new NoSuchFieldException("dynamic property \"" + name + "\" of proxy \"" + this.getAPIName() + "\" doesn't have read support");
    }

    protected void setDynamicProperty(Scriptable scope, String name, KrollProperty dynprop, Object value) throws NoSuchFieldException {
        if (!dynprop.supportsSet(name)) {
            throw new NoSuchFieldException("dynamic property \"" + name + "\" of proxy \"" + this.getAPIName() + "\" doesn't have write support");
        }
        KrollInvocation inv = KrollInvocation.createPropertySetInvocation(TiContext.getCurrentTiContext(), scope, (Scriptable)this.getKrollObject(), name, dynprop, this);
        dynprop.set(inv, name, value);
        inv.recycle();
    }

    public KrollDict getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.setProperty(name, value, false);
    }

    protected void firePropertyChanged(String name, Object oldValue, Object newValue) {
        if (this.modelListener != null) {
            if (this.context.isUIThread()) {
                this.modelListener.propertyChanged(name, oldValue, newValue, this);
            } else {
                KrollPropertyChange pch = new KrollPropertyChange(name, oldValue, newValue);
                this.getUIHandler().obtainMessage(100, (Object)pch).sendToTarget();
            }
        }
    }

    protected boolean shouldFireChange(Object oldValue, Object newValue) {
        return (oldValue != null || newValue != null) && (oldValue == null && newValue != null || newValue == null && oldValue != null || !oldValue.equals(newValue));
    }

    public void setProperty(String name, Object value, boolean fireChange) {
        Object current = this.properties.get(name);
        this.properties.put(name, value);
        if (fireChange && this.shouldFireChange(current, value)) {
            this.firePropertyChanged(name, current, value);
        }
    }

    public void extend(KrollDict options) {
        ArrayList<KrollPropertyChange> propertyChanges = new ArrayList<KrollPropertyChange>();
        for (String name : options.keySet()) {
            Object oldValue = this.properties.get(name);
            Object value = options.get(name);
            this.properties.put(name, value);
            if (!this.shouldFireChange(oldValue, value)) continue;
            KrollPropertyChange pch = new KrollPropertyChange(name, oldValue, value);
            propertyChanges.add(pch);
        }
        if (this.context.isUIThread()) {
            this.firePropertiesChanged(propertyChanges);
        } else {
            Message msg = this.getUIHandler().obtainMessage(103, propertyChanges);
            msg.sendToTarget();
        }
    }

    protected void firePropertiesChanged(List<KrollPropertyChange> changes) {
        if (this.modelListener != null) {
            this.modelListener.propertiesChanged(changes, this);
        }
    }

    public boolean hasBoundMethod(String methodName) {
        if (this.hasBinding(methodName)) {
            return this.getBinding(methodName) instanceof Function;
        }
        return false;
    }

    public boolean hasBoundProperty(String propertyName) {
        Object property2;
        return this.hasBinding(propertyName) && (property2 = this.getBinding(propertyName)) instanceof KrollProperty;
    }

    public KrollMethod getBoundMethod(String name) {
        return (KrollMethod)((Object)this.getBinding(name));
    }

    public KrollMethod getBoundMethodForThis(String name) {
        KrollMethod delegate = this.getBoundMethod(name);
        if (delegate != null) {
            return new ThisMethod(name, delegate);
        }
        return null;
    }

    public KrollProperty getBoundProperty(String name) {
        return (KrollProperty)this.getBinding(name);
    }

    public Object handleCreate(KrollInvocation invocation, Object[] args) {
        KrollModule createdInModule = (KrollModule)invocation.getProxy();
        Object[] createArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            createArgs[i] = KrollConverter.getInstance().convertJavascript(invocation, args[i], Object.class);
        }
        this.handleCreationArgs(createdInModule, createArgs);
        return KrollConverter.getInstance().convertNative(invocation, this);
    }

    public void handleCreationArgs(KrollModule createdInModule, Object[] args) {
        this.createdInModule = createdInModule;
        if (args.length >= 1 && args[0] instanceof KrollDict) {
            this.handleCreationDict((KrollDict)args[0]);
        }
    }

    public void handleCreationDict(KrollDict dict) {
        if (dict != null) {
            for (String key : dict.keySet()) {
                this.setProperty(key, dict.get(key), true);
            }
            this.creationDict = (KrollDict)dict.clone();
            if (this.modelListener != null) {
                this.modelListener.processProperties(this.creationDict);
            }
        }
    }

    public KrollDict getCreationDict() {
        return this.creationDict;
    }

    public KrollModule getCreatedInModule() {
        return this.createdInModule;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                KrollPropertyChange pch = (KrollPropertyChange)msg.obj;
                pch.fireEvent(this, this.modelListener);
                return true;
            }
            case 101: {
                if (this.modelListener != null) {
                    this.modelListener.listenerAdded(msg.getData().getString("eventName"), msg.arg1, (KrollProxy)msg.obj);
                }
                return true;
            }
            case 102: {
                if (this.modelListener != null) {
                    this.modelListener.listenerRemoved(msg.getData().getString("eventName"), msg.arg1, (KrollProxy)msg.obj);
                }
                return true;
            }
            case 103: {
                this.firePropertiesChanged((List)msg.obj);
                return true;
            }
        }
        return false;
    }

    public void setModelListener(KrollProxyListener modelListener) {
        if (this.modelListener != null && this.modelListener.equals(modelListener)) {
            return;
        }
        this.modelListener = modelListener;
        if (modelListener != null) {
            modelListener.processProperties((KrollDict)this.properties.clone());
        }
    }

    public TiContext switchContext(TiContext tiContext) {
        TiContext oldContext = this.context;
        this.context = tiContext;
        if (this.creatingContext == null) {
            this.creatingContext = oldContext;
        }
        return oldContext;
    }

    public void switchToCreatingContext() {
        if (this.creatingContext != null && this.context != null && !this.creatingContext.equals(this.context)) {
            this.switchContext(this.creatingContext);
        }
    }

    public Handler getUIHandler() {
        return this.uiHandler;
    }

    public Object sendBlockingUiMessage(int what, Object asyncArg) {
        AsyncResult result = new AsyncResult(asyncArg);
        return this.sendBlockingUiMessage(this.getUIHandler().obtainMessage(what, (Object)result), result);
    }

    public Object sendBlockingUiMessage(int what, int arg1) {
        AsyncResult result = new AsyncResult(null);
        return this.sendBlockingUiMessage(this.getUIHandler().obtainMessage(what, arg1, -1), result);
    }

    public Object sendBlockingUiMessage(int what, Object asyncArg, int arg1, int arg2) {
        AsyncResult result = new AsyncResult(asyncArg);
        return this.sendBlockingUiMessage(this.getUIHandler().obtainMessage(what, arg1, arg2, (Object)result), result);
    }

    public Object sendBlockingUiMessage(Message msg, AsyncResult result) {
        return TiMessageQueue.getMessageQueue().sendBlockingMessage(msg, TiMessageQueue.getMainMessageQueue(), result);
    }

    public TiContext getTiContext() {
        return this.context;
    }

    public KrollBridge getKrollBridge() {
        return this.context.getKrollBridge();
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public int addEventListener(KrollInvocation invocation, String eventName, Object listener) {
        int listenerId = -1;
        if (DBG) {
            Log.i(TAG, "Adding listener for \"" + eventName + "\": " + listener.getClass().getName());
        }
        listenerId = this.eventManager.addEventListener(eventName, listener);
        return listenerId;
    }

    public void removeEventListener(KrollInvocation invocation, String eventName, Object listener) {
        this.eventManager.removeEventListener(eventName, listener);
    }

    @Override
    public void eventListenerAdded(String eventName, int count, KrollProxy proxy2) {
        if (this.modelListener != null) {
            Message m = this.getUIHandler().obtainMessage(101, count, -1, (Object)proxy2);
            m.getData().putString("eventName", eventName);
            m.sendToTarget();
        }
    }

    @Override
    public void eventListenerRemoved(String eventName, int count, KrollProxy proxy2) {
        if (this.modelListener != null) {
            Message m = this.getUIHandler().obtainMessage(102, count, -1, (Object)proxy2);
            m.getData().putString("eventName", eventName);
            m.sendToTarget();
        }
    }

    public boolean fireEvent(String eventName, @Kroll.argument(optional=true) KrollDict data) {
        return this.eventManager.dispatchEvent(eventName, data);
    }

    public boolean fireSyncEvent(String eventName, @Kroll.argument(optional=true) KrollDict data) {
        return this.eventManager.dispatchEvent(eventName, data, false);
    }

    public KrollInvocation createEventInvocation(String eventName) {
        if (DBG) {
            Log.d(TAG, "creating event invocation, context: " + this.getTiContext() + ", js context: " + this.getTiContext().getKrollBridge());
        }
        KrollInvocation inv = KrollInvocation.createMethodInvocation(this.getTiContext(), this.getTiContext().getKrollBridge().getScope(), null, this.getAPIName() + ":event:" + eventName, null, this);
        return inv;
    }

    public void fireSingleEvent(String eventName, Object listener, KrollDict data, boolean asyncCallback) {
        if (listener != null) {
            KrollInvocation invocation = this.currentInvocation == null ? this.createEventInvocation(eventName) : this.currentInvocation;
            KrollMethod method2 = (KrollMethod)((Object)listener);
            if (data == null) {
                data = new KrollDict();
            }
            try {
                if (method2 instanceof KrollCallback && !asyncCallback) {
                    ((KrollCallback)method2).callSync(data);
                } else {
                    method2.invoke(invocation, new Object[]{data});
                }
            }
            catch (Exception e) {
                Log.e(TAG, e.getMessage(), e);
            }
            invocation.recycle();
        }
    }

    public boolean hasListeners(String eventName) {
        return this.eventManager.hasAnyEventListener(eventName);
    }

    protected KrollDict createErrorResponse(int code, String message) {
        KrollDict error = new KrollDict();
        error.put("code", code);
        error.put("message", message);
        return error;
    }

    public KrollInvocation getCurrentInvocation() {
        return this.currentInvocation;
    }

    public String toString() {
        return "[Ti." + this.getAPIName() + "]";
    }

    public Object getDefaultValue(Class<?> typeHint) {
        return this.toString();
    }

    @Override
    public Object getJavascriptValue() {
        return this.getKrollObject();
    }

    @Override
    public Object getNativeValue() {
        return this;
    }

    public class ThisMethod
    extends KrollMethod {
        protected String name;
        protected KrollMethod delegate;

        public ThisMethod(String name, KrollMethod delegate) {
            super(name);
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(KrollInvocation invocation, Object[] args) throws Exception {
            invocation.proxy = KrollProxy.this;
            invocation.thisObj = KrollProxy.this.getKrollObject();
            return this.delegate.invoke(invocation, args);
        }

        public KrollMethod getDelegate() {
            return this.delegate;
        }
    }
}

