/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import java.util.ArrayList;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProperty;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class KrollObject
extends ScriptableObject
implements Function {
    protected KrollProxy proxy;

    public KrollObject(KrollProxy proxy2) {
        this.proxy = proxy2;
    }

    public String getClassName() {
        return "Ti." + this.proxy.getAPIName() + (this.proxy instanceof KrollModule ? "Module" : "");
    }

    public Object[] getIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        ids.addAll(this.proxy.getProperties().keySet());
        for (String name : this.proxy.getBinding().bindings.keySet()) {
            KrollProperty property2;
            Object binding = this.proxy.getBinding().bindings.get(name);
            if (!(binding instanceof KrollProperty) || !(property2 = (KrollProperty)binding).supportsGet(name)) continue;
            ids.add(name);
        }
        return ids.toArray();
    }

    public Object[] getAllIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        ids.addAll(this.proxy.getProperties().keySet());
        ids.addAll(this.proxy.getBinding().bindings.keySet());
        return ids.toArray();
    }

    public Object get(String name, Scriptable start) {
        Object value = null;
        try {
            value = this.proxy.get(start, name);
            if (value != null && value.equals(KrollProxy.UNDEFINED)) {
                return Scriptable.NOT_FOUND;
            }
        }
        catch (NoSuchFieldException e) {
            return Scriptable.NOT_FOUND;
        }
        TiContext context = TiContext.getCurrentTiContext();
        Scriptable scope = start;
        if (context != null) {
            scope = context.getScope();
        }
        KrollInvocation invocation = KrollInvocation.createPropertyGetInvocation(context, scope, start, name, null, this.proxy);
        Object result = KrollConverter.getInstance().convertNative(invocation, value);
        invocation.recycle();
        return result;
    }

    public Object get(int index, Scriptable start) {
        return this.proxy.get(start, index);
    }

    public void put(String name, Scriptable start, Object value) {
        TiContext context = TiContext.getCurrentTiContext();
        Scriptable scope = start;
        if (context != null) {
            scope = context.getScope();
        }
        KrollInvocation invocation = KrollInvocation.createPropertyGetInvocation(context, scope, start, name, null, this.proxy);
        try {
            value = KrollConverter.getInstance().convertJavascript(invocation, value, Object.class);
            this.proxy.set(start, name, value);
        }
        catch (NoSuchFieldException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        invocation.recycle();
    }

    public void superPut(String name, Scriptable start, Object value) {
        super.put(name, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        this.proxy.set(start, index, value);
    }

    public boolean has(int index, Scriptable start) {
        return this.proxy.has(start, index);
    }

    public boolean has(String name, Scriptable start) {
        return this.proxy.has(start, name);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return null;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    public KrollProxy getProxy() {
        return this.proxy;
    }

    public Object getDefaultValue(Class<?> typeHint) {
        return this.proxy.getDefaultValue(typeHint);
    }

    protected Object equivalentValues(Object value) {
        if (value instanceof KrollObject) {
            KrollObject other = (KrollObject)((Object)value);
            return this.proxy.equals(other.getProxy()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.equivalentValues(value);
    }
}

