/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import android.app.Activity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModuleBinding;
import org.appcelerator.kroll.KrollModuleInfo;
import org.appcelerator.kroll.KrollPropertyChange;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.titanium.TiContext;

public class KrollModule
extends KrollProxy
implements KrollProxyListener,
TiContext.OnLifecycleEvent {
    private static final String TAG = "KrollModule";
    protected static HashMap<String, Object> constants = new HashMap();
    protected static HashMap<String, KrollModuleInfo> customModuleInfo = new HashMap();
    protected static HashMap<Class<? extends KrollModule>, List<Class<? extends KrollModule>>> externalChildModules = new HashMap();
    protected KrollModuleInfo moduleInfo;

    public static void addModuleInfo(KrollModuleInfo info) {
        customModuleInfo.put(info.getId(), info);
    }

    public static KrollModuleInfo getModuleInfo(String id) {
        return customModuleInfo.get(id);
    }

    public static Set<String> getCustomModuleIds() {
        return customModuleInfo.keySet();
    }

    public static void addExternalChildModule(Class<? extends KrollModule> parent, Class<? extends KrollModule> child) {
        if (!externalChildModules.containsKey(parent)) {
            externalChildModules.put(parent, new ArrayList());
        }
        externalChildModules.get(parent).add(child);
    }

    public KrollModule(TiContext context) {
        super(context);
        context.addOnLifecycleEventListener(this);
        this.modelListener = this;
        this.bindConstants();
        this.moduleInfo = KrollModule.getModuleInfo(this.getId());
    }

    public String getId() {
        return this.getModuleBinding().getId();
    }

    public KrollModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    protected KrollModuleBinding getModuleBinding() {
        return (KrollModuleBinding)this.getBinding();
    }

    public void bindToParent(KrollProxy parent) {
        KrollModuleBinding binding = this.getModuleBinding();
        binding.bindToParent(parent, this);
    }

    protected void bindConstants() {
        for (String name : constants.keySet()) {
            this.setProperty(name, constants.get(name));
        }
    }

    public static KrollModule getExternalChildModule(KrollModuleBinding binding, Class<? extends KrollModule> moduleClass, String name) {
        Object bindingObj;
        if (!externalChildModules.containsKey(moduleClass)) {
            return null;
        }
        if (binding.bindings.containsKey(name) && (bindingObj = binding.getBinding(name)) != null) {
            return (KrollModule)bindingObj;
        }
        for (Class<? extends KrollModule> childModuleClass : externalChildModules.get(moduleClass)) {
            KrollModuleBinding childBinding = (KrollModuleBinding)KrollProxy.getBinding(childModuleClass);
            if (childBinding == null || !childBinding.getShortAPIName().equals(name)) continue;
            KrollModule module2 = childBinding.newInstance(TiContext.getCurrentTiContext());
            binding.bindings.put(name, module2);
            return module2;
        }
        return null;
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onStop(Activity activity) {
    }

    @Override
    public void listenerAdded(String type, int count, KrollProxy proxy2) {
    }

    @Override
    public void listenerRemoved(String type, int count, KrollProxy proxy2) {
    }

    @Override
    public void processProperties(KrollDict d) {
    }

    @Override
    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy2) {
    }

    @Override
    public void propertiesChanged(List<KrollPropertyChange> changes, KrollProxy proxy2) {
        for (KrollPropertyChange change : changes) {
            this.propertyChanged(change.getName(), change.getOldValue(), change.getNewValue(), proxy2);
        }
    }
}

