/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public abstract class KrollMethod
extends BaseFunction
implements Function {
    private static final String TAG = "KrollMethod";
    protected String name;
    protected boolean runOnUiThread = false;

    public KrollMethod(String name) {
        this.name = name;
    }

    public String getClassName() {
        return TAG;
    }

    public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        KrollProxy proxy2 = null;
        if (thisObj instanceof KrollObject) {
            proxy2 = ((KrollObject)thisObj).getProxy();
        }
        Object methodResult = null;
        Exception exception = null;
        KrollInvocation inv = KrollInvocation.createMethodInvocation(scope, thisObj, this.name, this, proxy2);
        try {
            if (!this.runOnUiThread) {
                return this.invoke(inv, args);
            }
            if (inv.getTiContext().isUIThread()) {
                return this.invoke(inv, args);
            }
            final KrollInvocation fInv = inv;
            final Object[] fArgs = args;
            final AsyncResult result = new AsyncResult();
            TiMessageQueue.getMainMessageQueue().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object retVal = KrollMethod.this.invoke(fInv, fArgs);
                        result.setResult(retVal);
                    }
                    catch (Exception e) {
                        result.setResult(e);
                    }
                }
            });
            Object retVal = result.getResult();
            if (retVal instanceof Exception) {
                exception = (Exception)retVal;
                methodResult = Context.getUndefinedValue();
            } else {
                methodResult = retVal;
            }
        }
        catch (Exception e) {
            exception = e;
            methodResult = Context.getUndefinedValue();
        }
        inv.recycle();
        if (exception != null) {
            Log.e(TAG, "Exception calling kroll method " + this.name + ", invocation: " + inv, exception);
            Context.throwAsScriptRuntimeEx((Throwable)exception);
        }
        return methodResult;
    }

    public Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) {
        return null;
    }

    public abstract Object invoke(KrollInvocation var1, Object[] var2) throws Exception;

    public void setRunOnUiThread(boolean runOnUiThread) {
        this.runOnUiThread = runOnUiThread;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue(Class<?> typeHint) {
        return "[KrollMethod " + this.name + "]";
    }

    protected Object equivalentValues(Object value) {
        if (value instanceof KrollProxy.ThisMethod) {
            KrollProxy.ThisMethod other = (KrollProxy.ThisMethod)((Object)value);
            return ((Object)((Object)this)).equals((Object)other.getDelegate());
        }
        return super.equivalentValues(value);
    }
}

