/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import android.app.Activity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.appcelerator.kroll.KrollArgument;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollProperty;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.mozilla.javascript.Scriptable;

public class KrollInvocation {
    protected static Object invocationPoolSync = new Object();
    protected static KrollInvocation invocationPool = new KrollInvocation();
    protected static int poolSize = 0;
    protected static final int MAX_POOL_SIZE = 32;
    protected Scriptable scope;
    protected Scriptable thisObj;
    protected String name;
    protected boolean isPropertyGet;
    protected boolean isPropertySet;
    protected boolean isMethod;
    protected KrollMethod method;
    protected ArrayList<KrollArgument> arguments = new ArrayList();
    protected KrollProperty property;
    protected TiContext tiContext;
    protected KrollProxy proxy;
    protected KrollInvocation next;

    protected KrollInvocation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KrollInvocation obtainInvocation() {
        Object object = invocationPoolSync;
        synchronized (object) {
            if (invocationPool != null) {
                KrollInvocation inv = invocationPool;
                invocationPool = inv.next;
                inv.next = null;
                return inv;
            }
        }
        return new KrollInvocation();
    }

    public static KrollInvocation createMethodInvocation(Scriptable scope, Scriptable thisObj, String name, KrollMethod method2, KrollProxy proxy2) {
        return KrollInvocation.createMethodInvocation(TiContext.getCurrentTiContext(), scope, thisObj, name, method2, proxy2);
    }

    public static KrollInvocation createMethodInvocation(TiContext tiContext, Scriptable scope, Scriptable thisObj, String name, KrollMethod method2, KrollProxy proxy2) {
        KrollInvocation invocation = KrollInvocation.obtainInvocation();
        invocation.tiContext = tiContext;
        invocation.scope = scope;
        invocation.thisObj = thisObj;
        invocation.name = name;
        invocation.method = method2;
        invocation.isMethod = true;
        invocation.proxy = proxy2;
        return invocation;
    }

    public static KrollInvocation createPropertyGetInvocation(Scriptable scope, Scriptable thisObj, String name, KrollProperty property2, KrollProxy proxy2) {
        return KrollInvocation.createPropertyGetInvocation(TiContext.getCurrentTiContext(), scope, thisObj, name, property2, proxy2);
    }

    public static KrollInvocation createPropertyGetInvocation(TiContext tiContext, Scriptable scope, Scriptable thisObj, String name, KrollProperty property2, KrollProxy proxy2) {
        KrollInvocation invocation = KrollInvocation.obtainInvocation();
        invocation.tiContext = tiContext;
        invocation.scope = scope;
        invocation.thisObj = thisObj;
        invocation.name = name;
        invocation.isPropertyGet = true;
        invocation.property = property2;
        invocation.proxy = proxy2;
        return invocation;
    }

    public static KrollInvocation createPropertySetInvocation(Scriptable scope, Scriptable thisObj, String name, KrollProperty property2, KrollProxy proxy2) {
        return KrollInvocation.createPropertySetInvocation(TiContext.getCurrentTiContext(), scope, thisObj, name, property2, proxy2);
    }

    public static KrollInvocation createPropertySetInvocation(TiContext tiContext, Scriptable scope, Scriptable thisObj, String name, KrollProperty property2, KrollProxy proxy2) {
        KrollInvocation invocation = KrollInvocation.obtainInvocation();
        invocation.tiContext = tiContext;
        invocation.scope = scope;
        invocation.thisObj = thisObj;
        invocation.name = name;
        invocation.isPropertySet = true;
        invocation.property = property2;
        invocation.proxy = proxy2;
        return invocation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPropertyGet) {
            sb.append("[getProperty ");
        } else if (this.isPropertySet) {
            sb.append("[setProperty ");
        } else if (this.isMethod) {
            sb.append("[callMethod ");
        }
        if (this.proxy != null) {
            sb.append(this.proxy.getAPIName()).append(".");
        }
        sb.append(this.name).append(" ");
        if (this.isPropertyGet || this.isPropertySet) {
            sb.append(this.property);
        } else if (this.isMethod) {
            sb.append((Object)this.method);
            if (this.arguments != null) {
                Iterator<KrollArgument> iter = this.arguments.iterator();
                while (iter.hasNext()) {
                    KrollArgument arg = iter.next();
                    sb.append(arg);
                    if (!iter.hasNext()) continue;
                    sb.append(" ");
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public void addArgument(KrollArgument arg) {
        this.arguments.add(arg);
    }

    public List<KrollArgument> getArguments() {
        return this.arguments;
    }

    public KrollArgument getArgument(String name) {
        for (KrollArgument arg : this.arguments) {
            if (!arg.getName().equals(name)) continue;
            return arg;
        }
        return null;
    }

    public boolean isDefaultValue(String argName) {
        KrollArgument arg = this.getArgument(argName);
        if (arg != null) {
            return arg.isValueDefault;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = invocationPoolSync;
        synchronized (object) {
            if (poolSize < 32) {
                this.clearForRecycle();
                this.next = invocationPool;
                invocationPool = this;
            }
        }
    }

    public KrollInvocation copy() {
        KrollInvocation other = KrollInvocation.obtainInvocation();
        other.arguments = (ArrayList)this.arguments.clone();
        other.isMethod = this.isMethod;
        other.isPropertyGet = this.isPropertyGet;
        other.isPropertySet = this.isPropertySet;
        other.method = this.method;
        other.name = this.name;
        other.property = this.property;
        other.proxy = this.proxy;
        other.scope = this.scope;
        other.thisObj = this.thisObj;
        other.tiContext = this.tiContext;
        return other;
    }

    protected void clearForRecycle() {
        this.arguments.clear();
        this.isPropertySet = false;
        this.isPropertyGet = false;
        this.isMethod = false;
        this.method = null;
        this.name = null;
        this.property = null;
        this.proxy = null;
        this.scope = null;
        this.thisObj = null;
        this.tiContext = null;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPropertyGet() {
        return this.isPropertyGet;
    }

    public boolean isPropertySet() {
        return this.isPropertySet;
    }

    public KrollProperty getProperty() {
        return this.property;
    }

    public TiContext getTiContext() {
        return this.tiContext;
    }

    public Activity getActivity() {
        if (this.tiContext == null) {
            return null;
        }
        return this.tiContext.getActivity();
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public KrollMethod getMethod() {
        return this.method;
    }

    public KrollProxy getProxy() {
        return this.proxy;
    }
}

