/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import android.app.Activity;
import android.app.Service;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class KrollEventManager
implements TiContext.OnLifecycleEvent,
TiContext.OnServiceLifecycleEvent {
    private static final String TAG = "KrollEventManager";
    private static final boolean DBG = TiConfig.LOGD;
    private static final boolean TRACE = TiConfig.LOGV;
    protected KrollProxy proxy;
    protected ArrayList<WeakReference<OnEventListenerChange>> eventChangeListeners;
    protected Map<String, HashMap<Integer, KrollListener>> eventListeners;
    protected AtomicInteger listenerIdGenerator;

    public KrollEventManager(KrollProxy proxy2) {
        this.proxy = proxy2;
        TiContext tiContext = proxy2.getTiContext();
        if (tiContext.isServiceContext()) {
            tiContext.addOnServiceLifecycleEventListener(this);
        } else {
            tiContext.addOnLifecycleEventListener(this);
        }
        this.eventChangeListeners = new ArrayList();
        this.listenerIdGenerator = new AtomicInteger(0);
        this.eventListeners = Collections.synchronizedMap(new HashMap());
    }

    public void addOnEventChangeListener(OnEventListenerChange listener) {
        this.eventChangeListeners.add(new WeakReference<OnEventListenerChange>(listener));
    }

    public void removeOnEventChangeListener(OnEventListenerChange listener) {
        for (WeakReference<OnEventListenerChange> ref : this.eventChangeListeners) {
            OnEventListenerChange l = (OnEventListenerChange)ref.get();
            if (l == null || !l.equals(listener)) continue;
            this.eventChangeListeners.remove(ref);
            break;
        }
    }

    protected void dispatchOnEventChange(boolean added, String eventName, int count, KrollProxy proxy2) {
        for (WeakReference<OnEventListenerChange> ref : this.eventChangeListeners) {
            OnEventListenerChange l = (OnEventListenerChange)ref.get();
            if (l == null) continue;
            try {
                if (added) {
                    l.eventListenerAdded(eventName, count, proxy2);
                    continue;
                }
                l.eventListenerRemoved(eventName, count, proxy2);
            }
            catch (Throwable t) {
                Log.e(TAG, "Error invoking OnEventChangeListener: " + t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addEventListener(String eventName, Object listener) {
        int listenerId = -1;
        int listenerCount = 0;
        if (eventName == null) throw new IllegalStateException("addEventListener expects a non-null eventName");
        if (this.proxy == null) throw new IllegalStateException("addEventListener expects a non-null KrollProxy");
        if (listener == null) throw new IllegalStateException("addEventListener expects a non-null listener");
        Map<String, HashMap<Integer, KrollListener>> map = this.eventListeners;
        synchronized (map) {
            HashMap<Integer, KrollListener> listeners = this.eventListeners.get(eventName);
            if (listeners == null) {
                listeners = new HashMap();
                this.eventListeners.put(eventName, listeners);
            }
            listenerId = this.listenerIdGenerator.incrementAndGet();
            listeners.put(listenerId, new KrollListener(this.proxy, listener));
            if (DBG) {
                Log.d(TAG, "Added for eventName '" + eventName + "' with id " + listenerId);
            }
            listenerCount = listeners.size();
        }
        this.dispatchOnEventChange(true, eventName, listenerCount, this.proxy);
        return listenerId;
    }

    public void removeEventListener(String eventName, int listenerId) {
        if (eventName != null) {
            HashMap<Integer, KrollListener> listeners = this.eventListeners.get(eventName);
            if (listeners != null) {
                KrollListener listener = listeners.get(listenerId);
                if (listeners.remove(listenerId) == null) {
                    if (DBG) {
                        Log.w(TAG, "listenerId " + listenerId + " not for eventName '" + eventName + "'");
                    }
                } else {
                    this.dispatchOnEventChange(false, eventName, listeners.size(), listener.weakProxy.get());
                    if (DBG) {
                        Log.i(TAG, "listener with id " + listenerId + " with eventName '" + eventName + "' was removed.");
                    }
                }
            }
        } else {
            throw new IllegalStateException("removeEventListener expects a non-null eventName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(String eventName, Object listener) {
        if (listener instanceof Number) {
            this.removeEventListener(eventName, ((Number)listener).intValue());
            return;
        }
        boolean removed = false;
        int newCount = 0;
        SoftReference<KrollProxy> proxyOfListener = null;
        if (eventName != null) {
            Map<String, HashMap<Integer, KrollListener>> map = this.eventListeners;
            synchronized (map) {
                HashMap<Integer, KrollListener> listeners = this.eventListeners.get(eventName);
                if (listeners != null) {
                    for (Map.Entry<Integer, KrollListener> entry : listeners.entrySet()) {
                        Object l = entry.getValue().listener;
                        if (!l.equals(listener)) continue;
                        listeners.remove(entry.getKey());
                        removed = true;
                        newCount = listeners.size();
                        proxyOfListener = entry.getValue().weakProxy;
                        break;
                    }
                    if (!removed) {
                        Log.w(TAG, "listener not found for eventName '" + eventName + "'");
                    }
                }
            }
            if (removed) {
                this.dispatchOnEventChange(false, eventName, newCount, (KrollProxy)proxyOfListener.get());
            }
        } else {
            throw new IllegalStateException("removeEventListener expects a non-null eventName");
        }
    }

    public boolean hasAnyEventListener(String eventName) {
        boolean result = false;
        if (eventName != null) {
            HashMap<Integer, KrollListener> listeners = this.eventListeners.get(eventName);
            if (listeners != null) {
                result = !listeners.isEmpty();
            }
        } else {
            throw new IllegalStateException("removeEventListener expects a non-null eventName");
        }
        return result;
    }

    public boolean dispatchEvent(String eventName, KrollDict data) {
        return this.dispatchEvent(eventName, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchEvent(String eventName, KrollDict data, boolean asyncCallback) {
        boolean dispatched = false;
        if (eventName != null) {
            Map listeners = this.eventListeners.get(eventName);
            if (listeners == null) {
                if (TRACE) {
                    Log.w(TAG, "No listeners for eventName: " + eventName);
                }
                return false;
            }
            if (data == null) {
                data = new KrollDict();
            }
            if (!data.containsKey("type")) {
                data.put("type", eventName);
            }
            Set listenerSet = listeners.entrySet();
            Map<String, HashMap<Integer, KrollListener>> map = this.eventListeners;
            synchronized (map) {
                for (Map.Entry entry : listenerSet) {
                    KrollListener listener = (KrollListener)entry.getValue();
                    if (this.proxy != null && (this.proxy == null || !listener.isSameProxy(this.proxy))) continue;
                    boolean invoked = false;
                    try {
                        if (listener.weakProxy.get() != null) {
                            if (!data.containsKey("source")) {
                                data.put("source", listener.weakProxy.get());
                            }
                            invoked = listener.invoke(eventName, data, asyncCallback);
                        }
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Error invoking listener with id " + entry.getKey() + " on eventName '" + eventName + "'", e);
                    }
                    dispatched = dispatched || invoked;
                }
            }
        }
        throw new IllegalStateException("dispatchEvent expects a non-null eventName");
        return dispatched;
    }

    @Override
    public void onDestroy(Activity activity) {
        this.release();
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onStop(Activity activity) {
    }

    public void release() {
        if (this.eventChangeListeners != null) {
            this.eventChangeListeners.clear();
        }
        if (this.eventListeners != null) {
            this.eventListeners.clear();
        }
    }

    @Override
    public void onDestroy(Service service) {
        this.release();
    }

    public static class KrollListener {
        protected SoftReference<KrollProxy> weakProxy;
        protected Object listener;
        protected static final String TAG = "KrollListener";

        public KrollListener(KrollProxy proxy2, Object listener) {
            this.weakProxy = new SoftReference<KrollProxy>(proxy2);
            this.listener = listener;
        }

        public boolean invoke(String eventName, KrollDict data, boolean asyncCallback) {
            boolean invoked = false;
            KrollProxy p = this.weakProxy.get();
            if (p != null && this.listener != null) {
                p.fireSingleEvent(eventName, this.listener, data, asyncCallback);
                invoked = true;
            } else if (DBG) {
                Log.w(TAG, "Unable to fire event with eventName '" + eventName + "' references were garbage collected.");
            }
            return invoked;
        }

        public boolean isSameProxy(KrollProxy p) {
            KrollProxy localProxy = this.weakProxy.get();
            return p != null && localProxy != null && localProxy.equals(p);
        }
    }
}

