/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollJavascriptConverter;
import org.appcelerator.kroll.KrollNativeConverter;
import org.appcelerator.kroll.KrollProperty;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.mozilla.javascript.Context;

public abstract class KrollDynamicProperty
implements KrollProperty {
    private static final String TAG = "KrollReflectionProperty";
    protected static final String GET = "get";
    protected static final String SET = "set";
    protected boolean get;
    protected boolean set;
    protected boolean retain;
    protected String name;
    protected boolean runOnUiThread = false;
    protected KrollNativeConverter nativeConverter;
    protected KrollJavascriptConverter javascriptConverter;

    public KrollDynamicProperty(String name, boolean get, boolean set, boolean retain) {
        this.name = name;
        this.get = get;
        this.set = set;
        this.retain = retain;
    }

    protected Object safeInvoke(KrollInvocation invocation, String method2, Object value) {
        try {
            if (!this.runOnUiThread) {
                if (method2.equals(GET)) {
                    return this.dynamicGet(invocation);
                }
                this.dynamicSet(invocation, value);
                return null;
            }
            if (invocation.getTiContext().isUIThread()) {
                if (method2.equals(GET)) {
                    return this.dynamicGet(invocation);
                }
                this.dynamicSet(invocation, value);
                return null;
            }
            final KrollInvocation fInv = invocation;
            final Object fValue = value;
            final String fMethod = method2;
            final AsyncResult result = new AsyncResult();
            TiMessageQueue.getMainMessageQueue().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (fMethod.equals(KrollDynamicProperty.GET)) {
                            Object retVal = KrollDynamicProperty.this.dynamicGet(fInv);
                            result.setResult(retVal);
                        } else {
                            KrollDynamicProperty.this.dynamicSet(fInv, fValue);
                            result.setResult(null);
                        }
                    }
                    catch (Exception e) {
                        result.setException(e);
                    }
                }
            });
            return result.getResult();
        }
        catch (Exception e) {
            Log.e(TAG, "Exception getting/setting property: " + this.name, e);
            Context.throwAsScriptRuntimeEx((Throwable)e);
            return KrollProxy.UNDEFINED;
        }
    }

    @Override
    public Object get(KrollInvocation invocation, String name) {
        if (this.supportsGet(name)) {
            return this.safeInvoke(invocation, GET, null);
        }
        return this.nativeConverter.convertNative(invocation, invocation.getProxy().getProperty(name));
    }

    public abstract Object dynamicGet(KrollInvocation var1);

    @Override
    public void set(KrollInvocation invocation, String name, Object value) {
        if (this.supportsSet(name)) {
            if (this.retain) {
                invocation.getProxy().setProperty(name, value);
            }
            this.safeInvoke(invocation, SET, value);
        } else {
            Object convertedValue = this.javascriptConverter.convertJavascript(invocation, value, Object.class);
            invocation.getProxy().setProperty(name, convertedValue, true);
        }
    }

    public abstract void dynamicSet(KrollInvocation var1, Object var2);

    @Override
    public boolean supportsGet(String name) {
        return this.get;
    }

    @Override
    public boolean supportsSet(String name) {
        return this.set;
    }

    public void setRunOnUiThread(boolean runOnUiThread) {
        this.runOnUiThread = runOnUiThread;
    }

    public void setNativeConverter(KrollNativeConverter nativeConverter) {
        this.nativeConverter = nativeConverter;
    }

    public void setJavascriptConverter(KrollJavascriptConverter javascriptConverter) {
        this.javascriptConverter = javascriptConverter;
    }
}

