/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.appcelerator.kroll.KrollConverter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KrollDict
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_SIZE = 5;

    public KrollDict() {
        this(5);
    }

    public KrollDict(JSONObject object) throws JSONException {
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = object.get(key);
            Object json = KrollDict.fromJSON(value);
            this.put(key, json);
        }
    }

    public static Object fromJSON(Object value) {
        try {
            if (value instanceof JSONObject) {
                return new KrollDict((JSONObject)value);
            }
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                Object[] values = new Object[array.length()];
                for (int i = 0; i < array.length(); ++i) {
                    values[i] = KrollDict.fromJSON(array.get(i));
                }
                return values;
            }
        }
        catch (JSONException e) {
            Log.e((String)"KrollDict", (String)"Error parsing JSON", (Throwable)e);
        }
        return value;
    }

    public KrollDict(Map<? extends String, ? extends Object> map) {
        super(map);
    }

    public KrollDict(int size) {
        super(size);
    }

    public boolean containsKeyAndNotNull(String key) {
        return this.containsKey(key) && this.get(key) != null;
    }

    public boolean containsKeyStartingWith(String keyStartsWith) {
        if (this.keySet() != null) {
            for (String key : this.keySet()) {
                if (!key.startsWith(keyStartsWith)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getBoolean(String key) {
        return KrollConverter.toBoolean(this.get(key));
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (this.containsKey(key)) {
            result = this.getBoolean(key);
        }
        return result;
    }

    public String getString(String key) {
        return KrollConverter.toString(this.get(key));
    }

    public String optString(String key, String defalt) {
        if (this.containsKey(key)) {
            return this.getString(key);
        }
        return defalt;
    }

    public Integer getInt(String key) {
        return KrollConverter.toInt(this.get(key));
    }

    public Integer optInt(String key, Integer defaultValue) {
        Integer result = defaultValue;
        if (this.containsKey(key)) {
            result = this.getInt(key);
        }
        return result;
    }

    public Double getDouble(String key) {
        return KrollConverter.toDouble(this.get(key));
    }

    public String[] getStringArray(String key) {
        return KrollConverter.toStringArray((Object[])this.get(key));
    }

    public KrollDict getKrollDict(String key) {
        return (KrollDict)this.get(key);
    }

    public boolean isNull(String key) {
        return this.get(key) == null;
    }

    @Override
    public String toString() {
        return new JSONObject((Map)this).toString();
    }
}

