/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.kroll;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.appcelerator.kroll.KrollConvertable;
import org.appcelerator.kroll.KrollDate;
import org.appcelerator.kroll.KrollDefaultValueProvider;
import org.appcelerator.kroll.KrollDefaultValues;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollJavascriptConverter;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollNativeConverter;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollScriptableDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.kroll.KrollContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class KrollConverter
implements KrollNativeConverter,
KrollJavascriptConverter,
KrollDefaultValueProvider {
    private static final String TAG = "KrollConverter";
    private static final boolean DBG = TiConfig.DEBUG;
    public static final String DEFAULT_NAME = "__default_name__";
    public static final String JS_CLASS_DATE = "Date";
    public static final String JS_CLASS_ERROR = "Error";
    public static final String JS_CLASS_OBJECT = "Object";
    public static final String JS_METHOD_VALUE_OF = "valueOf";
    public static final String JS_METHOD_TO_STRING = "toString";
    public static final String JS_PROPERTY_JAVA_EXCEPTION = "javaException";
    public static final String JS_PROPERTY_LENGTH = "length";
    public static final String JS_PROPERTY_MESSAGE = "message";
    public static final String JS_UNDEFINED = "undefined";
    protected static KrollConverter _instance = new KrollConverter();

    public static KrollConverter getInstance() {
        return _instance;
    }

    public Object convertJSONObject(KrollInvocation invocation, JSONObject json) {
        if (json == JSONObject.NULL) {
            return Context.javaToJS(null, (Scriptable)invocation.getScope());
        }
        KrollDict map = new KrollDict();
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            try {
                Object entry = this.convertNative(invocation, json.get(name));
                map.put(name, entry);
            }
            catch (JSONException ig) {
                ig.printStackTrace();
            }
        }
        return this.convertNative(invocation, map);
    }

    public Object convertJSONArray(KrollInvocation invocation, JSONArray array) {
        Object[] result = new Object[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            try {
                Object r = array.get(i);
                result[i] = this.convertNative(invocation, r);
                continue;
            }
            catch (JSONException ig) {
                ig.printStackTrace();
            }
        }
        return Context.getCurrentContext().newArray(invocation.getScope(), result);
    }

    @Override
    public Object convertNative(KrollInvocation invocation, Object value) {
        if (value instanceof KrollConvertable) {
            return ((KrollConvertable)value).getJavascriptValue();
        }
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Scriptable || value instanceof Function) {
            return Context.javaToJS((Object)value, (Scriptable)invocation.getScope());
        }
        if (value instanceof JSONArray) {
            return this.convertJSONArray(invocation, (JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return this.convertJSONObject(invocation, (JSONObject)value);
        }
        if (value instanceof Map) {
            return new ScriptableMap(invocation, (Map)value);
        }
        if (value instanceof Date) {
            if (value instanceof KrollDate) {
                return ((KrollDate)value).getJSDate();
            }
            Date date = (Date)value;
            TiContext tiContext = invocation.getTiContext();
            return Context.getCurrentContext().newObject(tiContext.getKrollBridge().getScope(), JS_CLASS_DATE, new Object[]{date.getTime()});
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] jsArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                jsArray[i] = this.convertNative(invocation, Array.get(value, i));
            }
            return Context.getCurrentContext().newArray(invocation.getScope(), jsArray);
        }
        if (value == JSONObject.NULL || value.getClass().equals(JSONObject.NULL.getClass())) {
            return Context.javaToJS(null, (Scriptable)invocation.getScope());
        }
        if (value == KrollProxy.UNDEFINED) {
            return Context.getUndefinedValue();
        }
        return value;
    }

    public boolean isArrayLike(Scriptable scriptable) {
        return scriptable.has(JS_PROPERTY_LENGTH, scriptable) && scriptable.get(JS_PROPERTY_LENGTH, scriptable) instanceof Number && !(scriptable instanceof KrollObject) && !(scriptable instanceof Function) && scriptable.getClassName().equals("Array");
    }

    public Object[] toArray(KrollInvocation invocation, Scriptable scriptable) {
        int len = (Integer)Context.jsToJava((Object)scriptable.get(JS_PROPERTY_LENGTH, scriptable), Integer.class);
        Object[] a = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object v = scriptable.get(i, scriptable);
            if (DBG) {
                Log.d(TAG, "Index: " + i + " value: " + v + " type: " + v.getClass().getName());
            }
            a[i] = this.convertJavascript(invocation, v, Object.class);
        }
        return a;
    }

    public Object convertScriptable(KrollInvocation invocation, Scriptable scriptable) {
        if (scriptable instanceof KrollObject) {
            KrollProxy proxy2 = ((KrollObject)scriptable).getProxy();
            return proxy2.getNativeValue();
        }
        if (this.isArrayLike(scriptable)) {
            return this.toArray(invocation, scriptable);
        }
        if (scriptable.getClassName().equals(JS_CLASS_DATE)) {
            return new KrollDate(scriptable);
        }
        if (scriptable.getClassName().equals(JS_CLASS_ERROR)) {
            if (scriptable.has(JS_PROPERTY_JAVA_EXCEPTION, scriptable)) {
                NativeJavaObject exception = (NativeJavaObject)scriptable.get(JS_PROPERTY_JAVA_EXCEPTION, scriptable);
                return exception.unwrap();
            }
            return scriptable.get(JS_PROPERTY_MESSAGE, scriptable);
        }
        if (scriptable instanceof Function) {
            if (scriptable instanceof KrollCallback) {
                return scriptable;
            }
            KrollContext ctx = null;
            if (invocation.getTiContext() != null) {
                ctx = invocation.getTiContext().getKrollContext();
            }
            return new KrollCallback(ctx, invocation.getScope(), invocation.getThisObj(), (Function)scriptable);
        }
        return new KrollScriptableDict(scriptable);
    }

    public Object convertArray(KrollInvocation invocation, Object[] array, Class<?> target) {
        if (target.isArray()) {
            Object[] converted = null;
            Class<?> componentType = target.getComponentType();
            if (!componentType.equals(Object.class)) {
                if (componentType.equals(Integer.TYPE)) {
                    converted = new int[array.length];
                } else if (componentType.equals(Integer.class)) {
                    converted = new Integer[array.length];
                } else if (componentType.equals(Double.TYPE)) {
                    converted = new double[array.length];
                } else if (componentType.equals(Double.class)) {
                    converted = new Double[array.length];
                } else if (componentType.equals(String.class)) {
                    converted = new String[array.length];
                }
                if (converted != null) {
                    for (int i = 0; i < array.length; ++i) {
                        Array.set(converted, i, this.convertJavascript(invocation, array[i], componentType));
                    }
                    return converted;
                }
            }
        }
        Object[] newValues = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newValues[i] = this.convertJavascript(invocation, array[i], Object.class);
        }
        return newValues;
    }

    @Override
    public Object convertJavascript(KrollInvocation invocation, Object value, Class<?> target) {
        if (value instanceof Scriptable) {
            return this.convertScriptable(invocation, (Scriptable)value);
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return Context.jsToJava((Object)value, target);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Undefined) {
            return KrollProxy.UNDEFINED;
        }
        if (value.getClass().isArray()) {
            return this.convertArray(invocation, (Object[])value, target);
        }
        if (DBG) {
            Log.d(TAG, "Unhandled type conversion: value: " + value.toString() + " type: " + value.getClass().getName() + ", invocation: " + invocation);
        }
        return value;
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return KrollDefaultValues.getDefault(clazz);
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Unable to convert " + value.getClass().getName() + " to boolean.");
    }

    public static boolean toBoolean(KrollDict d, String key) {
        return KrollConverter.toBoolean(d.get(key));
    }

    public static int toInt(Object value) {
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static int toInt(KrollDict d, String key) {
        return KrollConverter.toInt(d.get(key));
    }

    public static float toFloat(Object value) {
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static float toFloat(KrollDict d, String key) {
        return KrollConverter.toFloat(d.get(key));
    }

    public static double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static double toDouble(KrollDict d, String key) {
        return KrollConverter.toDouble(d.get(key));
    }

    public static String toString(Object value) {
        return value == null ? null : (value == Scriptable.NOT_FOUND ? JS_UNDEFINED : value.toString());
    }

    public static String toString(KrollDict d, String key) {
        return KrollConverter.toString(d.get(key));
    }

    public static String[] toStringArray(Object[] parts) {
        String[] sparts;
        String[] stringArray = sparts = parts != null ? new String[parts.length] : new String[]{};
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                sparts[i] = parts[i] == null ? null : parts[i].toString();
            }
        }
        return sparts;
    }

    public class ScriptableMap
    extends ScriptableObject {
        protected Map<String, Object> map;

        public ScriptableMap(KrollInvocation invocation, Map<String, Object> map) {
            super(invocation.getScope(), ScriptableObject.getObjectPrototype((Scriptable)invocation.getScope()));
            this.map = map;
        }

        public Object get(String name, Scriptable start) {
            KrollInvocation invocation = KrollInvocation.createPropertyGetInvocation(start, (Scriptable)this, name, null, null);
            Object value = this.map.get(name);
            if (value == null && (name.equals(KrollConverter.JS_METHOD_VALUE_OF) || name.equals(KrollConverter.JS_METHOD_TO_STRING))) {
                value = new KrollMethod(name){

                    @Override
                    public Object invoke(KrollInvocation invocation, Object[] args) throws Exception {
                        return ScriptableMap.this.toString();
                    }
                };
            }
            Object result = KrollConverter.this.convertNative(invocation, value);
            invocation.recycle();
            return result;
        }

        public Object get(int index, Scriptable start) {
            return this.get("" + index, start);
        }

        public void put(String name, Scriptable start, Object value) {
            KrollInvocation invocation = KrollInvocation.createPropertySetInvocation(start, (Scriptable)this, name, null, null);
            this.map.put(name, KrollConverter.this.convertJavascript(invocation, value, Object.class));
            invocation.recycle();
        }

        public void put(int index, Scriptable start, Object value) {
            this.put("" + index, start, value);
        }

        public String getClassName() {
            return KrollConverter.JS_CLASS_OBJECT;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            Set<String> keys = this.map.keySet();
            String sep = "";
            for (String key : keys) {
                sb.append(" '").append(key).append("' : ");
                Object o = this.map.get(key);
                if (o == null) {
                    sb.append("null");
                } else if (o instanceof String) {
                    sb.append(" '").append((String)o).append("' ");
                } else if (o instanceof Number) {
                    sb.append(o);
                } else if (o instanceof ScriptableObject) {
                    sb.append(o);
                } else {
                    sb.append(o);
                }
                sb.append(sep);
                sep = ",";
            }
            sb.append(" }");
            return sb.toString();
        }

        public boolean has(String name, Scriptable start) {
            boolean exists = super.has(name, start);
            if (!exists && this.map != null) {
                exists = this.map.containsKey(name);
            }
            return exists;
        }

        public Object[] getIds() {
            if (this.map != null) {
                return this.map.keySet().toArray();
            }
            return super.getIds();
        }
    }
}

