/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.LimitedInputStream;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.LineReaderInputStreamAdaptor;
import org.apache.james.mime4j.io.MimeBoundaryInputStream;
import org.apache.james.mime4j.io.RootInputStream;
import org.apache.james.mime4j.parser.AbstractEntity;
import org.apache.james.mime4j.parser.EntityStateMachine;
import org.apache.james.mime4j.parser.Event;
import org.apache.james.mime4j.parser.MimeEntityConfig;
import org.apache.james.mime4j.parser.RawEntity;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeEntity
extends AbstractEntity {
    private static final int T_IN_BODYPART = -2;
    private static final int T_IN_MESSAGE = -3;
    private final RootInputStream rootStream;
    private final BufferedLineReaderInputStream inbuffer;
    private int recursionMode;
    private MimeBoundaryInputStream mimeStream;
    private LineReaderInputStreamAdaptor dataStream;
    private boolean skipHeader;
    private byte[] tmpbuf;

    public MimeEntity(RootInputStream rootStream, BufferedLineReaderInputStream inbuffer, BodyDescriptor parent, int startState, int endState, MimeEntityConfig config) {
        super(parent, startState, endState, config);
        this.rootStream = rootStream;
        this.inbuffer = inbuffer;
        this.dataStream = new LineReaderInputStreamAdaptor(inbuffer, config.getMaxLineLen());
        this.skipHeader = false;
    }

    public MimeEntity(RootInputStream rootStream, BufferedLineReaderInputStream inbuffer, BodyDescriptor parent, int startState, int endState) {
        this(rootStream, inbuffer, parent, startState, endState, new MimeEntityConfig());
    }

    public int getRecursionMode() {
        return this.recursionMode;
    }

    @Override
    public void setRecursionMode(int recursionMode) {
        this.recursionMode = recursionMode;
    }

    public void skipHeader(String contentType) {
        if (this.state != 0) {
            throw new IllegalStateException("Invalid state: " + MimeEntity.stateToString(this.state));
        }
        this.skipHeader = true;
        this.body.addField("Content-Type", contentType);
    }

    @Override
    protected int getLineNumber() {
        return this.rootStream.getLineNumber();
    }

    @Override
    protected LineReaderInputStream getDataStream() {
        return this.dataStream;
    }

    @Override
    public EntityStateMachine advance() throws IOException, MimeException {
        switch (this.state) {
            case 0: {
                if (this.skipHeader) {
                    this.state = 5;
                    break;
                }
                this.state = 3;
                break;
            }
            case 10: {
                this.state = 3;
                break;
            }
            case 3: 
            case 4: {
                this.state = this.parseField() ? 4 : 5;
                break;
            }
            case 5: {
                String mimeType = this.body.getMimeType();
                if (this.recursionMode == 3) {
                    this.state = 12;
                    break;
                }
                if (MimeUtil.isMultipart(mimeType)) {
                    this.state = 6;
                    this.clearMimeStream();
                    break;
                }
                if (this.recursionMode != 1 && MimeUtil.isMessage(mimeType)) {
                    this.state = -3;
                    return this.nextMessage();
                }
                this.state = 12;
                break;
            }
            case 6: {
                if (this.dataStream.isUsed()) {
                    this.advanceToBoundary();
                    this.state = 7;
                    break;
                }
                this.createMimeStream();
                this.state = 8;
                break;
            }
            case 8: {
                this.advanceToBoundary();
                if (this.mimeStream.isLastPart()) {
                    this.clearMimeStream();
                    this.state = 7;
                    break;
                }
                this.clearMimeStream();
                this.createMimeStream();
                this.state = -2;
                return this.nextMimeEntity();
            }
            case -2: {
                this.advanceToBoundary();
                if (this.mimeStream.eof() && !this.mimeStream.isLastPart()) {
                    this.monitor(Event.MIME_BODY_PREMATURE_END);
                } else if (!this.mimeStream.isLastPart()) {
                    this.clearMimeStream();
                    this.createMimeStream();
                    this.state = -2;
                    return this.nextMimeEntity();
                }
                this.clearMimeStream();
                this.state = 9;
                break;
            }
            case 9: {
                this.state = 7;
                break;
            }
            case -3: 
            case 7: 
            case 12: {
                this.state = this.endState;
                break;
            }
            default: {
                if (this.state == this.endState) {
                    this.state = -1;
                    break;
                }
                throw new IllegalStateException("Invalid state: " + MimeEntity.stateToString(this.state));
            }
        }
        return null;
    }

    private void createMimeStream() throws IOException {
        String boundary = this.body.getBoundary();
        int bufferSize = 2 * boundary.length();
        if (bufferSize < 4096) {
            bufferSize = 4096;
        }
        try {
            if (this.mimeStream != null) {
                this.mimeStream = new MimeBoundaryInputStream(new BufferedLineReaderInputStream(this.mimeStream, bufferSize, this.config.getMaxLineLen()), boundary);
            } else {
                this.inbuffer.ensureCapacity(bufferSize);
                this.mimeStream = new MimeBoundaryInputStream(this.inbuffer, boundary);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MimeException(e.getMessage(), e);
        }
        this.dataStream = new LineReaderInputStreamAdaptor(this.mimeStream, this.config.getMaxLineLen());
    }

    private void clearMimeStream() {
        this.mimeStream = null;
        this.dataStream = new LineReaderInputStreamAdaptor(this.inbuffer, this.config.getMaxLineLen());
    }

    private void advanceToBoundary() throws IOException {
        if (!this.dataStream.eof()) {
            if (this.tmpbuf == null) {
                this.tmpbuf = new byte[2048];
            }
            InputStream instream = this.getLimitedContentStream();
            while (instream.read(this.tmpbuf) != -1) {
            }
        }
    }

    private EntityStateMachine nextMessage() {
        InputStream instream;
        String transferEncoding = this.body.getTransferEncoding();
        if (MimeUtil.isBase64Encoding(transferEncoding)) {
            this.log.debug((Object)"base64 encoded message/rfc822 detected");
            instream = new Base64InputStream(this.dataStream);
        } else if (MimeUtil.isQuotedPrintableEncoded(transferEncoding)) {
            this.log.debug((Object)"quoted-printable encoded message/rfc822 detected");
            instream = new QuotedPrintableInputStream(this.dataStream);
        } else {
            instream = this.dataStream;
        }
        if (this.recursionMode == 2) {
            RawEntity message = new RawEntity(instream);
            return message;
        }
        MimeEntity message = new MimeEntity(this.rootStream, new BufferedLineReaderInputStream(instream, 4096, this.config.getMaxLineLen()), this.body, 0, 1, this.config);
        message.setRecursionMode(this.recursionMode);
        return message;
    }

    private EntityStateMachine nextMimeEntity() {
        if (this.recursionMode == 2) {
            RawEntity message = new RawEntity(this.mimeStream);
            return message;
        }
        BufferedLineReaderInputStream stream = new BufferedLineReaderInputStream(this.mimeStream, 4096, this.config.getMaxLineLen());
        MimeEntity mimeentity = new MimeEntity(this.rootStream, stream, this.body, 10, 11, this.config);
        mimeentity.setRecursionMode(this.recursionMode);
        return mimeentity;
    }

    private InputStream getLimitedContentStream() {
        long maxContentLimit = this.config.getMaxContentLen();
        if (maxContentLimit >= 0L) {
            return new LimitedInputStream(this.dataStream, maxContentLimit);
        }
        return this.dataStream;
    }

    @Override
    public InputStream getContentStream() {
        switch (this.state) {
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                return this.getLimitedContentStream();
            }
        }
        throw new IllegalStateException("Invalid state: " + MimeEntity.stateToString(this.state));
    }
}

