/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.message.storage.TempFile;
import org.apache.james.mime4j.message.storage.TempPath;
import org.apache.james.mime4j.message.storage.TempStorage;

public class SimpleTempStorage
extends TempStorage {
    private static Log log = LogFactory.getLog(SimpleTempStorage.class);
    private TempPath rootPath = null;
    private Random random = new Random();

    public SimpleTempStorage() {
        this.rootPath = new SimpleTempPath(System.getProperty("java.io.tmpdir"));
    }

    private TempPath createTempPath(TempPath parent, String prefix) throws IOException {
        long n;
        if (prefix == null) {
            prefix = "";
        }
        File p = null;
        int count = 1000;
        do {
            n = Math.abs(this.random.nextLong());
        } while ((p = new File(parent.getAbsolutePath(), prefix + n)).exists() && --count > 0);
        if (p.exists() || !p.mkdirs()) {
            log.error((Object)("Unable to mkdirs on " + p.getAbsolutePath()));
            throw new IOException("Creating dir '" + p.getAbsolutePath() + "' failed.");
        }
        return new SimpleTempPath(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempFile createTempFile(TempPath parent, String prefix, String suffix) throws IOException {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        File f = null;
        int count = 1000;
        SimpleTempStorage simpleTempStorage = this;
        synchronized (simpleTempStorage) {
            long n;
            do {
                n = Math.abs(this.random.nextLong());
            } while ((f = new File(parent.getAbsolutePath(), prefix + n + suffix)).exists() && --count > 0);
            if (f.exists()) {
                throw new IOException("Creating temp file failed: Unable to find unique file name");
            }
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("Creating dir '" + f.getAbsolutePath() + "' failed.");
            }
        }
        return new SimpleTempFile(f);
    }

    @Override
    public TempPath getRootTempPath() {
        return this.rootPath;
    }

    private static class SimpleTempFile
    implements TempFile {
        private File file = null;
        private static final Set filesToDelete = new HashSet();

        private SimpleTempFile(File file) {
            this.file = file;
            this.file.deleteOnExit();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new BufferedOutputStream(new FileOutputStream(this.file));
        }

        @Override
        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            Set set = filesToDelete;
            synchronized (set) {
                if (this.file != null) {
                    filesToDelete.add(this.file);
                    this.file = null;
                }
                Iterator iterator = filesToDelete.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (!file.delete()) continue;
                    iterator.remove();
                }
            }
        }

        @Override
        public boolean isInMemory() {
            return false;
        }

        @Override
        public long length() {
            return this.file.length();
        }
    }

    private class SimpleTempPath
    implements TempPath {
        private File path = null;

        private SimpleTempPath(String path) {
            this.path = new File(path);
        }

        private SimpleTempPath(File path) {
            this.path = path;
        }

        @Override
        public TempFile createTempFile() throws IOException {
            return SimpleTempStorage.this.createTempFile(this, null, null);
        }

        @Override
        public TempFile createTempFile(String prefix, String suffix) throws IOException {
            return SimpleTempStorage.this.createTempFile(this, prefix, suffix);
        }

        @Override
        public TempFile createTempFile(String prefix, String suffix, boolean allowInMemory) throws IOException {
            return SimpleTempStorage.this.createTempFile(this, prefix, suffix);
        }

        @Override
        public String getAbsolutePath() {
            return this.path.getAbsolutePath();
        }

        @Override
        public void delete() {
        }

        @Override
        public TempPath createTempPath() throws IOException {
            return SimpleTempStorage.this.createTempPath(this, null);
        }

        @Override
        public TempPath createTempPath(String prefix) throws IOException {
            return SimpleTempStorage.this.createTempPath(this, prefix);
        }
    }
}

