/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.TempFileBinaryBody;
import org.apache.james.mime4j.message.TempFileTextBody;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.util.CharArrayBuffer;

public class MessageBuilder
implements ContentHandler {
    private final Entity entity;
    private Stack stack = new Stack();

    public MessageBuilder(Entity entity) {
        this.entity = entity;
    }

    private void expect(Class c) {
        if (!c.isInstance(this.stack.peek())) {
            throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
        }
    }

    @Override
    public void startMessage() throws MimeException {
        if (this.stack.isEmpty()) {
            this.stack.push(this.entity);
        } else {
            this.expect(Entity.class);
            Message m = new Message();
            ((Entity)this.stack.peek()).setBody(m);
            this.stack.push(m);
        }
    }

    @Override
    public void endMessage() throws MimeException {
        this.expect(Message.class);
        this.stack.pop();
    }

    @Override
    public void startHeader() throws MimeException {
        this.stack.push(new Header());
    }

    @Override
    public void field(String fieldData) throws MimeException {
        this.expect(Header.class);
        ((Header)this.stack.peek()).addField(Field.parse(fieldData));
    }

    @Override
    public void endHeader() throws MimeException {
        this.expect(Header.class);
        Header h = (Header)this.stack.pop();
        this.expect(Entity.class);
        ((Entity)this.stack.peek()).setHeader(h);
    }

    @Override
    public void startMultipart(BodyDescriptor bd) throws MimeException {
        this.expect(Entity.class);
        Entity e = (Entity)this.stack.peek();
        String subType = bd.getSubType();
        Multipart multiPart = new Multipart(subType);
        e.setBody(multiPart);
        this.stack.push(multiPart);
    }

    @Override
    public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
        this.expect(Entity.class);
        String enc = bd.getTransferEncoding();
        InputStream decodedStream = "base64".equals(enc) ? new Base64InputStream(is) : ("quoted-printable".equals(enc) ? new QuotedPrintableInputStream(is) : is);
        AbstractBody body = bd.getMimeType().startsWith("text/") ? new TempFileTextBody(decodedStream, bd.getCharset()) : new TempFileBinaryBody(decodedStream);
        Entity entity = (Entity)this.stack.peek();
        entity.setBody(body);
    }

    @Override
    public void endMultipart() throws MimeException {
        this.stack.pop();
    }

    @Override
    public void startBodyPart() throws MimeException {
        this.expect(Multipart.class);
        BodyPart bodyPart = new BodyPart();
        ((Multipart)this.stack.peek()).addBodyPart(bodyPart);
        this.stack.push(bodyPart);
    }

    @Override
    public void endBodyPart() throws MimeException {
        this.expect(BodyPart.class);
        this.stack.pop();
    }

    @Override
    public void epilogue(InputStream is) throws MimeException, IOException {
        int b;
        this.expect(Multipart.class);
        CharArrayBuffer sb = new CharArrayBuffer(128);
        while ((b = is.read()) != -1) {
            sb.append((char)b);
        }
        ((Multipart)this.stack.peek()).setEpilogue(sb.toString());
    }

    @Override
    public void preamble(InputStream is) throws MimeException, IOException {
        int b;
        this.expect(Multipart.class);
        CharArrayBuffer sb = new CharArrayBuffer(128);
        while ((b = is.read()) != -1) {
            sb.append((char)b);
        }
        ((Multipart)this.stack.peek()).setPreamble(sb.toString());
    }

    @Override
    public void raw(InputStream is) throws MimeException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }
}

