/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.decoder.CodecUtil;
import org.apache.james.mime4j.field.ContentTransferEncodingField;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.Disposable;
import org.apache.james.mime4j.message.Header;

public abstract class Entity
implements Disposable {
    private Header header = null;
    private Body body = null;
    private Entity parent = null;

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
        body.setParent(this);
    }

    public String getMimeType() {
        ContentTypeField child = (ContentTypeField)this.getHeader().getField("Content-Type");
        ContentTypeField parent = this.getParent() != null ? (ContentTypeField)this.getParent().getHeader().getField("Content-Type") : null;
        return ContentTypeField.getMimeType(child, parent);
    }

    public String getCharset() {
        return ContentTypeField.getCharset((ContentTypeField)this.getHeader().getField("Content-Type"));
    }

    public String getContentTransferEncoding() {
        ContentTransferEncodingField f = (ContentTransferEncodingField)this.getHeader().getField("Content-Transfer-Encoding");
        return ContentTransferEncodingField.getEncoding(f);
    }

    public boolean isMimeType(String type) {
        return this.getMimeType().equalsIgnoreCase(type);
    }

    public boolean isMultipart() {
        ContentTypeField f = (ContentTypeField)this.getHeader().getField("Content-Type");
        return f != null && f.getBoundary() != null && this.getMimeType().startsWith("multipart/");
    }

    public void writeTo(OutputStream out, int mode) throws IOException, MimeException {
        this.getHeader().writeTo(out, mode);
        out.flush();
        Body body = this.getBody();
        OutputStream encOut = "base64".equals(this.getContentTransferEncoding()) ? CodecUtil.wrapBase64(out) : ("quoted-printable".equals(this.getContentTransferEncoding()) ? CodecUtil.wrapQuotedPrintable(out, body instanceof BinaryBody) : out);
        body.writeTo(encOut, mode);
        encOut.flush();
        if (encOut != out) {
            encOut.close();
        }
    }

    @Override
    public void dispose() {
        if (this.body != null) {
            this.body.dispose();
        }
    }
}

