/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CloseShieldInputStream
extends FilterInputStream {
    public CloseShieldInputStream(InputStream is) {
        super(is);
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in = null;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkIfClosed();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.in != null) {
            this.in.mark(readlimit);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkIfClosed();
        return this.in.skip(n);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkIfClosed();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkIfClosed();
        return this.in.read(b, off, len);
    }

    private void checkIfClosed() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream is closed");
        }
    }
}

