/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.contenttype.parser.ContentTypeParser;
import org.apache.james.mime4j.field.contenttype.parser.ParseException;
import org.apache.james.mime4j.field.contenttype.parser.TokenMgrError;

public class ContentTypeField
extends Field {
    public static final String TYPE_MULTIPART_PREFIX = "multipart/";
    public static final String TYPE_MULTIPART_DIGEST = "multipart/digest";
    public static final String TYPE_TEXT_PLAIN = "text/plain";
    public static final String TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String PARAM_BOUNDARY = "boundary";
    public static final String PARAM_CHARSET = "charset";
    private String mimeType = "";
    private Map parameters = null;
    private ParseException parseException;

    protected ContentTypeField(String name, String body, String raw, String mimeType, Map parameters, ParseException parseException) {
        super(name, body, raw);
        this.mimeType = mimeType;
        this.parameters = parameters;
        this.parseException = parseException;
    }

    public ParseException getParseException() {
        return this.parseException;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static String getMimeType(ContentTypeField child, ContentTypeField parent) {
        if (child == null || child.getMimeType().length() == 0 || child.isMultipart() && child.getBoundary() == null) {
            if (parent != null && parent.isMimeType(TYPE_MULTIPART_DIGEST)) {
                return TYPE_MESSAGE_RFC822;
            }
            return TYPE_TEXT_PLAIN;
        }
        return child.getMimeType();
    }

    public String getParameter(String name) {
        return this.parameters != null ? (String)this.parameters.get(name.toLowerCase()) : null;
    }

    public Map getParameters() {
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : Collections.EMPTY_MAP;
    }

    public String getBoundary() {
        return this.getParameter(PARAM_BOUNDARY);
    }

    public String getCharset() {
        return this.getParameter(PARAM_CHARSET);
    }

    public static String getCharset(ContentTypeField f) {
        if (f != null && f.getCharset() != null && f.getCharset().length() > 0) {
            return f.getCharset();
        }
        return "us-ascii";
    }

    public boolean isMimeType(String mimeType) {
        return this.mimeType.equalsIgnoreCase(mimeType);
    }

    public boolean isMultipart() {
        return this.mimeType.startsWith(TYPE_MULTIPART_PREFIX);
    }

    public static class Parser
    implements FieldParser {
        private static Log log = LogFactory.getLog(Parser.class);

        @Override
        public Field parse(String name, String body, String raw) {
            ParseException parseException = null;
            String mimeType = "";
            HashMap<String, String> parameters = null;
            ContentTypeParser parser = new ContentTypeParser(new StringReader(body));
            try {
                parser.parseAll();
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
                }
                parseException = e;
            }
            catch (TokenMgrError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
                }
                parseException = new ParseException(e.getMessage());
            }
            try {
                String type = parser.getType();
                String subType = parser.getSubType();
                if (type != null && subType != null) {
                    mimeType = (type + "/" + parser.getSubType()).toLowerCase();
                    ArrayList paramNames = parser.getParamNames();
                    ArrayList paramValues = parser.getParamValues();
                    if (paramNames != null && paramValues != null) {
                        for (int i = 0; i < paramNames.size() && i < paramValues.size(); ++i) {
                            if (parameters == null) {
                                parameters = new HashMap<String, String>((int)((double)paramNames.size() * 1.3 + 1.0));
                            }
                            String paramName = ((String)paramNames.get(i)).toLowerCase();
                            String paramValue = (String)paramValues.get(i);
                            parameters.put(paramName, paramValue);
                        }
                    }
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            return new ContentTypeField(name, body, raw, mimeType, parameters, parseException);
        }
    }
}

