/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.FieldParser;

public class ContentTransferEncodingField
extends Field {
    private String encoding;

    protected ContentTransferEncodingField(String name, String body, String raw, String encoding) {
        super(name, body, raw);
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static String getEncoding(ContentTransferEncodingField f) {
        if (f != null && f.getEncoding().length() != 0) {
            return f.getEncoding();
        }
        return "7bit";
    }

    public static class Parser
    implements FieldParser {
        @Override
        public Field parse(String name, String body, String raw) {
            String encoding = body.trim().toLowerCase();
            return new ContentTransferEncodingField(name, body, raw, encoding);
        }
    }
}

