/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.descriptor;

import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.descriptor.DefaultBodyDescriptor;
import org.apache.james.mime4j.descriptor.RFC1864ContentMD5Descriptor;
import org.apache.james.mime4j.descriptor.RFC2045MimeDescriptor;
import org.apache.james.mime4j.descriptor.RFC2183ContentDispositionDescriptor;
import org.apache.james.mime4j.descriptor.RFC2557ContentLocationDescriptor;
import org.apache.james.mime4j.descriptor.RFC3066ContentLanguageDescriptor;
import org.apache.james.mime4j.field.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.mime4j.field.language.ContentLanguageParser;
import org.apache.james.mime4j.field.mimeversion.MimeVersionParser;
import org.apache.james.mime4j.field.structured.StructuredFieldParser;
import org.apache.james.mime4j.util.MimeUtil;

public class MaximalBodyDescriptor
extends DefaultBodyDescriptor
implements RFC2045MimeDescriptor,
RFC2183ContentDispositionDescriptor,
RFC3066ContentLanguageDescriptor,
RFC2557ContentLocationDescriptor,
RFC1864ContentMD5Descriptor {
    private static final int DEFAULT_MINOR_VERSION = 0;
    private static final int DEFAULT_MAJOR_VERSION = 1;
    private boolean isMimeVersionSet = false;
    private int mimeMinorVersion = 0;
    private int mimeMajorVersion = 1;
    private MimeException mimeVersionException;
    private String contentId = null;
    private boolean isContentIdSet = false;
    private String contentDescription = null;
    private boolean isContentDescriptionSet = false;
    private String contentDispositionType = null;
    private Map contentDispositionParameters = Collections.EMPTY_MAP;
    private DateTime contentDispositionModificationDate = null;
    private MimeException contentDispositionModificationDateParseException = null;
    private DateTime contentDispositionCreationDate = null;
    private MimeException contentDispositionCreationDateParseException = null;
    private DateTime contentDispositionReadDate = null;
    private MimeException contentDispositionReadDateParseException = null;
    private long contentDispositionSize = -1L;
    private MimeException contentDispositionSizeParseException = null;
    private boolean isContentDispositionSet = false;
    private List contentLanguage = null;
    private MimeException contentLanguageParseException = null;
    private boolean isContentLanguageSet;
    private MimeException contentLocationParseException = null;
    private String contentLocation = null;
    private boolean isContentLocationSet = false;
    private String contentMD5Raw = null;
    private boolean isContentMD5Set = false;

    protected MaximalBodyDescriptor() {
        this(null);
    }

    public MaximalBodyDescriptor(BodyDescriptor parent) {
        super(parent);
    }

    @Override
    public void addField(String name, String value) {
        if ("mime-version".equals(name = name.trim().toLowerCase()) && !this.isMimeVersionSet) {
            this.parseMimeVersion(value);
        } else if ("content-id".equals(name) && !this.isContentIdSet) {
            this.parseContentId(value);
        } else if ("content-description".equals(name) && !this.isContentDescriptionSet) {
            this.parseContentDescription(value);
        } else if ("content-disposition".equals(name) && !this.isContentDispositionSet) {
            this.parseContentDisposition(value);
        } else if ("content-language".equals(name) && !this.isContentLanguageSet) {
            this.parseLanguage(value);
        } else if ("content-location".equals(name) && !this.isContentLocationSet) {
            this.parseLocation(value);
        } else if ("content-md5".equals(name) && !this.isContentMD5Set) {
            this.parseMD5(value);
        } else {
            super.addField(name, value);
        }
    }

    private void parseMD5(String value) {
        this.isContentMD5Set = true;
        if (value != null) {
            this.contentMD5Raw = value.trim();
        }
    }

    private void parseLocation(String value) {
        this.isContentLocationSet = true;
        if (value != null) {
            StringReader stringReader = new StringReader(value);
            StructuredFieldParser parser = new StructuredFieldParser(stringReader);
            parser.setFoldingPreserved(false);
            try {
                this.contentLocation = parser.parse();
            }
            catch (MimeException e) {
                this.contentLocationParseException = e;
            }
        }
    }

    private void parseLanguage(String value) {
        this.isContentLanguageSet = true;
        if (value != null) {
            try {
                ContentLanguageParser parser = new ContentLanguageParser(new StringReader(value));
                this.contentLanguage = parser.parse();
            }
            catch (MimeException e) {
                this.contentLanguageParseException = e;
            }
        }
    }

    private void parseContentDisposition(String value) {
        String size;
        String contentDispositionReadDate;
        String contentDispositionCreationDate;
        this.isContentDispositionSet = true;
        this.contentDispositionParameters = MimeUtil.getHeaderParams(value);
        this.contentDispositionType = (String)this.contentDispositionParameters.get("");
        String contentDispositionModificationDate = (String)this.contentDispositionParameters.get("modification-date");
        if (contentDispositionModificationDate != null) {
            try {
                this.contentDispositionModificationDate = this.parseDate(contentDispositionModificationDate);
            }
            catch (ParseException e) {
                this.contentDispositionModificationDateParseException = e;
            }
        }
        if ((contentDispositionCreationDate = (String)this.contentDispositionParameters.get("creation-date")) != null) {
            try {
                this.contentDispositionCreationDate = this.parseDate(contentDispositionCreationDate);
            }
            catch (ParseException e) {
                this.contentDispositionCreationDateParseException = e;
            }
        }
        if ((contentDispositionReadDate = (String)this.contentDispositionParameters.get("read-date")) != null) {
            try {
                this.contentDispositionReadDate = this.parseDate(contentDispositionReadDate);
            }
            catch (ParseException e) {
                this.contentDispositionReadDateParseException = e;
            }
        }
        if ((size = (String)this.contentDispositionParameters.get("size")) != null) {
            try {
                this.contentDispositionSize = Long.parseLong(size);
            }
            catch (NumberFormatException e) {
                this.contentDispositionSizeParseException = (MimeException)new MimeException(e.getMessage(), e).fillInStackTrace();
            }
        }
        this.contentDispositionParameters.remove("");
    }

    private DateTime parseDate(String date) throws ParseException {
        StringReader stringReader = new StringReader(date);
        DateTimeParser parser = new DateTimeParser(stringReader);
        DateTime result = parser.date_time();
        return result;
    }

    private void parseContentDescription(String value) {
        this.contentDescription = value == null ? "" : value.trim();
        this.isContentDescriptionSet = true;
    }

    private void parseContentId(String value) {
        this.contentId = value == null ? "" : value.trim();
        this.isContentIdSet = true;
    }

    private void parseMimeVersion(String value) {
        StringReader reader = new StringReader(value);
        MimeVersionParser parser = new MimeVersionParser(reader);
        try {
            int minor;
            parser.parse();
            int major = parser.getMajorVersion();
            if (major != -1) {
                this.mimeMajorVersion = major;
            }
            if ((minor = parser.getMinorVersion()) != -1) {
                this.mimeMinorVersion = minor;
            }
        }
        catch (MimeException e) {
            this.mimeVersionException = e;
        }
        this.isMimeVersionSet = true;
    }

    @Override
    public int getMimeMajorVersion() {
        return this.mimeMajorVersion;
    }

    @Override
    public int getMimeMinorVersion() {
        return this.mimeMinorVersion;
    }

    @Override
    public MimeException getMimeVersionParseException() {
        return this.mimeVersionException;
    }

    @Override
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getContentDispositionType() {
        return this.contentDispositionType;
    }

    @Override
    public Map getContentDispositionParameters() {
        return this.contentDispositionParameters;
    }

    @Override
    public String getContentDispositionFilename() {
        return (String)this.contentDispositionParameters.get("filename");
    }

    @Override
    public DateTime getContentDispositionModificationDate() {
        return this.contentDispositionModificationDate;
    }

    @Override
    public MimeException getContentDispositionModificationDateParseException() {
        return this.contentDispositionModificationDateParseException;
    }

    @Override
    public DateTime getContentDispositionCreationDate() {
        return this.contentDispositionCreationDate;
    }

    @Override
    public MimeException getContentDispositionCreationDateParseException() {
        return this.contentDispositionCreationDateParseException;
    }

    @Override
    public DateTime getContentDispositionReadDate() {
        return this.contentDispositionReadDate;
    }

    @Override
    public MimeException getContentDispositionReadDateParseException() {
        return this.contentDispositionReadDateParseException;
    }

    @Override
    public long getContentDispositionSize() {
        return this.contentDispositionSize;
    }

    @Override
    public MimeException getContentDispositionSizeParseException() {
        return this.contentDispositionSizeParseException;
    }

    @Override
    public List getContentLanguage() {
        return this.contentLanguage;
    }

    @Override
    public MimeException getContentLanguageParseException() {
        return this.contentLanguageParseException;
    }

    @Override
    public String getContentLocation() {
        return this.contentLocation;
    }

    @Override
    public MimeException getContentLocationParseException() {
        return this.contentLocationParseException;
    }

    @Override
    public String getContentMD5Raw() {
        return this.contentMD5Raw;
    }
}

