/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.util.CharArrayBuffer;
import org.apache.james.mime4j.util.CharsetUtil;

public class DecoderUtil {
    private static Log log = LogFactory.getLog(DecoderUtil.class);

    public static byte[] decodeBaseQuotedPrintable(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            QuotedPrintableInputStream is = new QuotedPrintableInputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return baos.toByteArray();
    }

    public static byte[] decodeBase64(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            Base64InputStream is = new Base64InputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return baos.toByteArray();
    }

    public static String decodeB(String encodedWord, String charset) throws UnsupportedEncodingException {
        return new String(DecoderUtil.decodeBase64(encodedWord), charset);
    }

    public static String decodeQ(String encodedWord, String charset) throws UnsupportedEncodingException {
        CharArrayBuffer sb = new CharArrayBuffer(128);
        for (int i = 0; i < encodedWord.length(); ++i) {
            char c = encodedWord.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return new String(DecoderUtil.decodeBaseQuotedPrintable(sb.toString()), charset);
    }

    public static String decodeEncodedWords(String body) {
        CharArrayBuffer sb = new CharArrayBuffer(128);
        int p1 = 0;
        try {
            for (int p2 = 0; p2 < body.length(); p2 += 2) {
                int t1;
                p1 = body.indexOf("=?", p2);
                if (p1 == -1) {
                    sb.append(body.substring(p2));
                    break;
                }
                if (p1 - p2 > 0) {
                    sb.append(body.substring(p2, p1));
                }
                int t2 = (t1 = body.indexOf(63, p1 + 2)) != -1 ? body.indexOf(63, t1 + 1) : -1;
                int n = p2 = t2 != -1 ? body.indexOf("?=", t2 + 1) : -1;
                if (p2 == -1) {
                    if (t2 == -1 || body.length() - 1 != t2 && body.charAt(t2 + 1) != '=') {
                        sb.append(body.substring(p1));
                        break;
                    }
                    p2 = t2;
                }
                String decodedWord = null;
                if (t2 == p2) {
                    decodedWord = "";
                } else {
                    String mimeCharset = body.substring(p1 + 2, t1);
                    String enc = body.substring(t1 + 1, t2);
                    String encodedWord = body.substring(t2 + 1, p2);
                    String charset = CharsetUtil.toJavaCharset(mimeCharset);
                    if (charset == null) {
                        decodedWord = body.substring(p1, p2 + 2);
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("MIME charset '" + mimeCharset + "' in header field doesn't have a " + "corresponding Java charset"));
                        }
                    } else if (!CharsetUtil.isDecodingSupported(charset)) {
                        decodedWord = body.substring(p1, p2 + 2);
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Current JDK doesn't support decoding of charset '" + charset + "' (MIME charset '" + mimeCharset + "')"));
                        }
                    } else if (enc.equalsIgnoreCase("Q")) {
                        decodedWord = DecoderUtil.decodeQ(encodedWord, charset);
                    } else if (enc.equalsIgnoreCase("B")) {
                        decodedWord = DecoderUtil.decodeB(encodedWord, charset);
                    } else {
                        decodedWord = encodedWord;
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Warning: Unknown encoding in header field '" + enc + "'"));
                        }
                    }
                }
                sb.append(decodedWord);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Decoding header field body '" + body + "'"), t);
        }
        return sb.toString();
    }
}

