/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.util.Collections;
import java.util.Map;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.message.AbstractBody;

public abstract class AbstractContentBody
extends AbstractBody
implements ContentBody {
    private final String mimeType;
    private final String mediaType;
    private final String subType;

    public AbstractContentBody(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        this.mimeType = mimeType;
        int i = mimeType.indexOf(47);
        if (i != -1) {
            this.mediaType = mimeType.substring(0, i);
            this.subType = mimeType.substring(i + 1);
        } else {
            this.mediaType = mimeType;
            this.subType = null;
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public Map<?, ?> getContentTypeParameters() {
        return Collections.EMPTY_MAP;
    }
}

