/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.xml;

import android.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlSerializer;
import ti.modules.titanium.xml.DocumentProxy;
import ti.modules.titanium.xml.NodeProxy;

public class XMLModule
extends KrollModule {
    private static DocumentBuilder builder;
    private static final String LCAT = "XMLModule";

    public XMLModule(TiContext context) {
        super(context);
    }

    public DocumentProxy parseString(String xml) {
        return XMLModule.parse(this.getTiContext(), xml);
    }

    public static DocumentProxy parse(TiContext context, String xml) {
        return XMLModule.parse(context, xml, System.getProperty("file.encoding", "UTF-8"));
    }

    public static DocumentProxy parse(TiContext context, String xml, String encoding) {
        if (builder != null) {
            try {
                return new DocumentProxy(context, builder.parse(new ByteArrayInputStream(xml.getBytes(encoding))));
            }
            catch (SAXException e) {
                Log.e((String)LCAT, (String)"Error parsing XML", (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)LCAT, (String)"Error reading XML", (Throwable)e);
            }
        }
        return null;
    }

    public String serializeToString(NodeProxy node) {
        StringWriter writer = new StringWriter();
        XmlSerializer out = Xml.newSerializer();
        try {
            out.setOutput((Writer)writer);
            this.serializeNode(out, node.getNode());
            out.endDocument();
            return writer.toString();
        }
        catch (Exception e) {
            Log.e((String)LCAT, (String)"Error serializing XML", (Throwable)e);
            return null;
        }
    }

    private void serializeNode(XmlSerializer out, Node node) throws IOException {
        switch (node.getNodeType()) {
            case 2: {
                out.attribute(this.namespaceFor(node), this.nameFor(node), node.getNodeValue());
                break;
            }
            case 4: {
                out.cdsect(node.getNodeValue());
                break;
            }
            case 8: {
                out.comment(node.getNodeValue());
                break;
            }
            case 9: {
                this.serializeNode(out, ((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                String ns = this.namespaceFor(node);
                String name = this.nameFor(node);
                out.startTag(ns, name);
                NamedNodeMap attribs = node.getAttributes();
                if (attribs != null) {
                    int length = attribs.getLength();
                    for (int i = 0; i < length; ++i) {
                        this.serializeNode(out, attribs.item(i));
                    }
                }
                NodeList children = node.getChildNodes();
                int length = children.getLength();
                for (int i = 0; i < length; ++i) {
                    this.serializeNode(out, children.item(i));
                }
                out.endTag(ns, name);
                break;
            }
            case 5: {
                out.entityRef(node.getNodeName());
                break;
            }
            case 7: {
                out.processingInstruction(node.getNodeValue());
                break;
            }
            case 3: {
                out.text(node.getNodeValue());
                break;
            }
            default: {
                Log.e((String)LCAT, (String)("Skipping unrecognized node of type " + node.getNodeType()));
            }
        }
    }

    private String namespaceFor(Node node) {
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return "";
        }
        return ns;
    }

    private String nameFor(Node node) {
        if (node.getNamespaceURI() == null) {
            return node.getNodeName();
        }
        return node.getLocalName();
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Log.e((String)LCAT, (String)"Error finding DOM implementation", (Throwable)e);
        }
    }
}

