/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.xml;

import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import ti.modules.titanium.xml.AttrProxy;
import ti.modules.titanium.xml.CDATASectionProxy;
import ti.modules.titanium.xml.CommentProxy;
import ti.modules.titanium.xml.DocumentFragmentProxy;
import ti.modules.titanium.xml.DocumentProxy;
import ti.modules.titanium.xml.DocumentTypeProxy;
import ti.modules.titanium.xml.ElementProxy;
import ti.modules.titanium.xml.EntityProxy;
import ti.modules.titanium.xml.EntityReferenceProxy;
import ti.modules.titanium.xml.NamedNodeMapProxy;
import ti.modules.titanium.xml.NodeListProxy;
import ti.modules.titanium.xml.NotationProxy;
import ti.modules.titanium.xml.ProcessingInstructionProxy;
import ti.modules.titanium.xml.TextProxy;
import ti.modules.titanium.xml.XPathNodeListProxy;
import ti.modules.titanium.xml.XPathUtil;

public class NodeProxy
extends KrollProxy {
    public static final int ATTRIBUTE_NODE = 2;
    public static final int CDATA_SECTION_NODE = 4;
    public static final int COMMENT_NODE = 8;
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    public static final int DOCUMENT_NODE = 9;
    public static final int DOCUMENT_TYPE_NODE = 10;
    public static final int ELEMENT_NODE = 1;
    public static final int ENTITY_NODE = 6;
    public static final int ENTITY_REFERENCE_NODE = 5;
    public static final int NOTATION_NODE = 12;
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    public static final int TEXT_NODE = 3;
    private Node node;

    public NodeProxy(TiContext context, Node node) {
        super(context);
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public static NodeProxy getNodeProxy(TiContext context, Node node) {
        NodeProxy proxy;
        switch (node.getNodeType()) {
            case 2: {
                proxy = new AttrProxy(context, (Attr)node);
                break;
            }
            case 4: {
                proxy = new CDATASectionProxy(context, (CDATASection)node);
                break;
            }
            case 8: {
                proxy = new CommentProxy(context, (Comment)node);
                break;
            }
            case 11: {
                proxy = new DocumentFragmentProxy(context, (DocumentFragment)node);
                break;
            }
            case 9: {
                proxy = new DocumentProxy(context, (Document)node);
                break;
            }
            case 10: {
                proxy = new DocumentTypeProxy(context, (DocumentType)node);
                break;
            }
            case 1: {
                proxy = new ElementProxy(context, (Element)node);
                break;
            }
            case 6: {
                proxy = new EntityProxy(context, (Entity)node);
                break;
            }
            case 5: {
                proxy = new EntityReferenceProxy(context, (EntityReference)node);
                break;
            }
            case 12: {
                proxy = new NotationProxy(context, (Notation)node);
                break;
            }
            case 7: {
                proxy = new ProcessingInstructionProxy(context, (ProcessingInstruction)node);
                break;
            }
            case 3: {
                proxy = new TextProxy(context, (Text)node);
                break;
            }
            default: {
                proxy = new NodeProxy(context, node);
            }
        }
        return proxy;
    }

    public static NodeProxy removeProxyForNode(TiContext context, Node node) {
        return new NodeProxy(context, node);
    }

    protected <T extends NodeProxy> T getProxy(Node node) {
        return (T)((Object)NodeProxy.getNodeProxy(this.getTiContext(), node));
    }

    public NodeProxy appendChild(NodeProxy newChild) throws DOMException {
        return this.getProxy(this.node.appendChild(newChild.node));
    }

    public NodeProxy cloneNode(boolean deep) {
        return this.getProxy(this.node.cloneNode(deep));
    }

    public NamedNodeMapProxy getAttributes() {
        return new NamedNodeMapProxy(this.getTiContext(), this.node.getAttributes());
    }

    public NodeListProxy getChildNodes() {
        return new NodeListProxy(this.getTiContext(), this.node.getChildNodes());
    }

    public NodeProxy getFirstChild() {
        return this.getProxy(this.node.getFirstChild());
    }

    public NodeProxy getLastChild() {
        return this.getProxy(this.node.getLastChild());
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    public NodeProxy getNextSibling() {
        return this.getProxy(this.node.getNextSibling());
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    public short getNodeType() {
        return this.node.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    public DocumentProxy getOwnerDocument() {
        return new DocumentProxy(this.getTiContext(), this.node.getOwnerDocument());
    }

    public NodeProxy getParentNode() {
        return this.getProxy(this.node.getParentNode());
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public NodeProxy getPreviousSibling() {
        return this.getProxy(this.node.getPreviousSibling());
    }

    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public NodeProxy insertBefore(NodeProxy newChild, NodeProxy refChild) throws DOMException {
        return this.getProxy(this.node.insertBefore(newChild.node, refChild.node));
    }

    public boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    public void normalize() {
        this.node.normalize();
    }

    public NodeProxy removeChild(NodeProxy oldChild) throws DOMException {
        Node oldNode = this.node.removeChild(oldChild.node);
        return NodeProxy.removeProxyForNode(this.getTiContext(), oldNode);
    }

    public NodeProxy replaceChild(NodeProxy newChild, NodeProxy oldChild) throws DOMException {
        Node oldNode = this.node.replaceChild(newChild.node, oldChild.node);
        return NodeProxy.removeProxyForNode(this.getTiContext(), oldNode);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.node.setNodeValue(nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        this.node.setPrefix(prefix);
    }

    public XPathNodeListProxy evaluate(String xpath) {
        return XPathUtil.evaluate(this, xpath);
    }
}

