/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.xml;

import org.appcelerator.titanium.TiContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import ti.modules.titanium.xml.AttrProxy;
import ti.modules.titanium.xml.NodeListProxy;
import ti.modules.titanium.xml.NodeProxy;

public class ElementProxy
extends NodeProxy {
    private Element element;

    public ElementProxy(TiContext context, Element element) {
        super(context, element);
        this.element = element;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        this.getTextImpl(this.element, sb);
        return sb.toString();
    }

    private void getTextImpl(Node node, StringBuilder builder) {
        NodeList children = node.getChildNodes();
        block5: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    builder.append(((Text)child).getNodeValue());
                    continue block5;
                }
                case 4: {
                    builder.append(((CDATASection)child).getData());
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.getTextImpl(child, builder);
                    continue block5;
                }
            }
        }
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public AttrProxy getAttributeNode(String name) {
        return (AttrProxy)((Object)this.getProxy(this.element.getAttributeNode(name)));
    }

    public AttrProxy getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (AttrProxy)((Object)this.getProxy(this.element.getAttributeNodeNS(namespaceURI, localName)));
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.element.getAttributeNS(namespaceURI, localName);
    }

    protected NodeListProxy filterThisFromNodeList(NodeList list) {
        int offset = 0;
        if (list.getLength() > 0 && list.item(0).equals(this.element)) {
            offset = 1;
        }
        return new NodeListProxy(this.getTiContext(), list, offset);
    }

    public NodeListProxy getElementsByTagName(String name) {
        return this.filterThisFromNodeList(this.element.getElementsByTagName(name));
    }

    public NodeListProxy getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return this.filterThisFromNodeList(this.element.getElementsByTagNameNS(namespaceURI, localName));
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.element.hasAttributeNS(namespaceURI, localName);
    }

    public void removeAttribute(String name) throws DOMException {
        this.element.removeAttribute(name);
    }

    public AttrProxy removeAttributeNode(AttrProxy oldAttr) throws DOMException {
        return (AttrProxy)((Object)this.getProxy(this.element.removeAttributeNode(oldAttr.getAttr())));
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.element.removeAttributeNS(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.element.setAttribute(name, value);
    }

    public AttrProxy setAttributeNode(AttrProxy newAttr) throws DOMException {
        return (AttrProxy)((Object)this.getProxy(this.element.setAttributeNode(newAttr.getAttr())));
    }

    public AttrProxy setAttributeNodeNS(AttrProxy newAttr) throws DOMException {
        return (AttrProxy)((Object)this.getProxy(this.element.setAttributeNodeNS(newAttr.getAttr())));
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.element.setAttributeNS(namespaceURI, qualifiedName, value);
    }
}

