/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;

public class UtilsModule
extends KrollModule {
    private static final String LCAT = "UtilsModule";

    public UtilsModule(TiContext tiContext) {
        super(tiContext);
    }

    public TiBlob base64encode(Object obj) {
        if (obj instanceof TiBlob) {
            return TiBlob.blobFromString((TiContext)this.getTiContext(), (String)((TiBlob)obj).toBase64());
        }
        try {
            String data = obj instanceof byte[] ? new String((byte[])obj, "UTF-8") : TiConvert.toString((Object)obj);
            return TiBlob.blobFromString((TiContext)this.getTiContext(), (String)new String(Base64.encodeBase64((byte[])data.getBytes("UTF-8")), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LCAT, (String)"UTF-8 is not a supported encoding type");
            return null;
        }
    }

    public TiBlob base64decode(String data) {
        try {
            return TiBlob.blobFromData((TiContext)this.getTiContext(), (byte[])Base64.decodeBase64((byte[])data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LCAT, (String)"UTF-8 is not a supported encoding type");
            return null;
        }
    }

    public String md5HexDigest(String data) {
        return DigestUtils.md5Hex((String)data);
    }

    public String sha1(String data) {
        try {
            byte[] b = data.getBytes();
            MessageDigest algorithm = MessageDigest.getInstance("SHA-1");
            algorithm.reset();
            algorithm.update(b);
            byte[] messageDigest = algorithm.digest();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                result.append(Integer.toString((messageDigest[i] & 0xFF) + 256, 16).substring(1));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)LCAT, (String)"SHA1 is not a supported algorithm");
            return null;
        }
    }

    public String transcodeString(String orig, String inEncoding, String outEncoding) {
        try {
            Charset charsetOut = Charset.forName(outEncoding);
            Charset charsetIn = Charset.forName(inEncoding);
            ByteBuffer bufferIn = ByteBuffer.wrap(orig.getBytes(charsetIn.name()));
            CharBuffer dataIn = charsetIn.decode(bufferIn);
            bufferIn.clear();
            bufferIn = null;
            ByteBuffer bufferOut = charsetOut.encode(dataIn);
            dataIn.clear();
            dataIn = null;
            byte[] dataOut = bufferOut.array();
            bufferOut.clear();
            bufferOut = null;
            return new String(dataOut, charsetOut.name());
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LCAT, (String)("Unsupported encoding: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

