/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.webview;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.HttpAuthHandler;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.media.TiVideoActivity;
import ti.modules.titanium.ui.widget.webview.TiUIWebView;
import ti.modules.titanium.ui.widget.webview.TiWebViewBinding;

public class TiWebViewClient
extends WebViewClient {
    private static final String LCAT = "TiWVC";
    private static final boolean DBG = TiConfig.LOGD;
    private TiUIWebView webView;
    private TiWebViewBinding binding;
    private String username;
    private String password;

    public TiWebViewClient(TiUIWebView tiWebView, WebView webView) {
        this.webView = tiWebView;
        this.binding = new TiWebViewBinding(tiWebView.getProxy().getTiContext(), webView);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.webView.changeProxyUrl(url);
        KrollDict data = new KrollDict();
        data.put((Object)"url", (Object)url);
        this.webView.getProxy().fireEvent("load", data);
    }

    public TiWebViewBinding getBinding() {
        return this.binding;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        KrollDict data = new KrollDict();
        data.put((Object)"url", (Object)url);
        this.webView.getProxy().fireEvent("beforeload", data);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        String text = "Javascript Error(" + errorCode + "): " + description;
        Log.e((String)LCAT, (String)("Received on error" + text));
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (DBG) {
            Log.d((String)LCAT, (String)("url=" + url));
        }
        if (URLUtil.isAssetUrl((String)url) || URLUtil.isContentUrl((String)url) || URLUtil.isFileUrl((String)url)) {
            this.webView.getProxy().setProperty("url", (Object)url, true);
            return true;
        }
        if (url.startsWith("tel:")) {
            Log.i((String)LCAT, (String)("Launching dialer for " + url));
            Intent dialer = Intent.createChooser((Intent)new Intent("android.intent.action.DIAL", Uri.parse((String)url)), (CharSequence)"Choose Dialer");
            this.webView.getProxy().getTiContext().getActivity().startActivity(dialer);
            return true;
        }
        if (url.startsWith("mailto:")) {
            Log.i((String)LCAT, (String)("Launching mailer for " + url));
            Intent mailer = Intent.createChooser((Intent)new Intent("android.intent.action.SENDTO", Uri.parse((String)url)), (CharSequence)"Send Message");
            this.webView.getProxy().getTiContext().getActivity().startActivity(mailer);
            return true;
        }
        if (url.startsWith("geo:0,0?q=")) {
            Log.i((String)LCAT, (String)("Launching app for " + url));
            Intent geoviewer = Intent.createChooser((Intent)new Intent("android.intent.action.VIEW", Uri.parse((String)url)), (CharSequence)"Choose Viewer");
            this.webView.getProxy().getTiContext().getActivity().startActivity(geoviewer);
            return true;
        }
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        if (mimeType != null) {
            return this.shouldHandleMimeType(mimeType, url);
        }
        if (DBG) {
            Log.e((String)LCAT, (String)("NEED to Handle " + url));
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    private boolean shouldHandleMimeType(String mimeType, String url) {
        if (mimeType.startsWith("video/")) {
            Intent intent = new Intent();
            intent.setClass(this.webView.getProxy().getContext(), TiVideoActivity.class);
            intent.putExtra("contentURL", url);
            intent.putExtra("play", true);
            this.webView.getProxy().getTiContext().getActivity().startActivity(intent);
            return true;
        }
        return false;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        if (this.username != null && this.password != null) {
            handler.proceed(this.username, this.password);
        }
    }

    public void setBasicAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }
}

