/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.webview;

import android.webkit.WebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Semaphore;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.Scriptable;
import ti.modules.titanium.api.APIModule;
import ti.modules.titanium.app.AppModule;

public class TiWebViewBinding {
    private static final String LCAT = "TiWebViewBinding";
    protected static final String SCRIPT_INJECTION_ID = "__ti_injection";
    protected static final String INJECTION_CODE;
    private WebView webView;
    private APIBinding apiBinding;
    private AppBinding appBinding;
    private Semaphore returnSemaphore = new Semaphore(0);
    private String returnValue;

    public TiWebViewBinding(TiContext context, WebView webView) {
        this.webView = webView;
        this.apiBinding = new APIBinding(context);
        this.appBinding = new AppBinding(context);
        webView.addJavascriptInterface((Object)this.apiBinding, "TiAPI");
        webView.addJavascriptInterface((Object)this.appBinding, "TiApp");
        webView.addJavascriptInterface((Object)new TiReturn(), "_TiReturn");
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder readResourceFile(String fileName) {
        InputStream stream = TiWebViewBinding.class.getClassLoader().getResourceAsStream("ti/modules/titanium/ui/widget/webview/" + fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder code = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                code.append(line + "\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)"Error reading input stream", (Throwable)e);
            StringBuilder stringBuilder = null;
            return stringBuilder;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Log.w((String)LCAT, (String)"Problem closing input stream.", (Throwable)e);
                }
            }
        }
        return code;
    }

    private void evalJS(String code) {
        this.webView.loadUrl("javascript:" + code);
    }

    public String getJSValue(String expression) {
        String code = "javascript:_TiReturn.setValue((function(){try{return " + expression + "+\"\";}catch(ti_eval_err){return '';}})());";
        Log.d((String)LCAT, (String)("getJSValue:" + code));
        this.webView.loadUrl(code);
        try {
            this.returnSemaphore.acquire();
            return this.returnValue;
        }
        catch (InterruptedException e) {
            Log.e((String)LCAT, (String)"Interrupted", (Throwable)e);
            return null;
        }
    }

    static {
        StringBuilder jsonCode = TiWebViewBinding.readResourceFile("json2.js");
        StringBuilder tiCode = TiWebViewBinding.readResourceFile("binding.min.js");
        StringBuilder allCode = new StringBuilder();
        allCode.append("\n<script id=\"__ti_injection\">\n");
        if (jsonCode == null) {
            Log.w((String)LCAT, (String)"Unable to read JSON code for injection");
        } else {
            allCode.append((CharSequence)jsonCode);
        }
        if (tiCode == null) {
            Log.w((String)LCAT, (String)"Unable to read Titanium binding code for injection");
        } else {
            allCode.append("\n");
            allCode.append(tiCode.toString());
        }
        allCode.append("\n</script>\n");
        jsonCode = null;
        tiCode = null;
        INJECTION_CODE = allCode.toString();
        Object var2_2 = null;
    }

    private class AppBinding {
        private AppModule module;

        public AppBinding(TiContext context) {
            this.module = (AppModule)context.getTiApp().getModuleByClass(AppModule.class);
        }

        public void fireEvent(String event, String json) {
            try {
                KrollDict dict = new KrollDict();
                if (json != null && !json.equals("undefined")) {
                    dict = new KrollDict(new JSONObject(json));
                }
                this.module.fireEvent(event, dict);
            }
            catch (JSONException e) {
                Log.e((String)TiWebViewBinding.LCAT, (String)"Error parsing event JSON", (Throwable)e);
            }
        }

        public int addEventListener(String event, int id) {
            KrollInvocation invocation = KrollInvocation.createMethodInvocation((TiContext)this.module.getTiContext(), (Scriptable)this.module.getTiContext().getScope(), null, (String)"addEventListener", null, (KrollProxy)this.module);
            int listenerId = this.module.addEventListener(invocation, event, (Object)new WebViewCallback(id));
            invocation.recycle();
            return listenerId;
        }

        public void removeEventListener(String event, int id) {
            KrollInvocation invocation = KrollInvocation.createMethodInvocation((TiContext)this.module.getTiContext(), (Scriptable)this.module.getTiContext().getScope(), null, (String)"removeEventListener", null, (KrollProxy)this.module);
            this.module.removeEventListener(invocation, event, (Object)id);
            invocation.recycle();
        }
    }

    private class APIBinding {
        private APIModule module;

        public APIBinding(TiContext context) {
            this.module = (APIModule)context.getTiApp().getModuleByClass(APIModule.class);
        }

        public void critical(String msg) {
            this.module.critical((Object)msg);
        }

        public void debug(String msg) {
            this.module.debug((Object)msg);
        }

        public void error(String msg) {
            this.module.error((Object)msg);
        }

        public void fatal(String msg) {
            this.module.fatal((Object)msg);
        }

        public void info(String msg) {
            this.module.info((Object)msg);
        }

        public void log(String level, String msg) {
            this.module.log(level, (Object)msg);
        }

        public void notice(String msg) {
            this.module.notice((Object)msg);
        }

        public void trace(String msg) {
            this.module.trace((Object)msg);
        }

        public void warn(String msg) {
            this.module.warn((Object)msg);
        }
    }

    private class WebViewCallback
    extends KrollMethod {
        private int id;

        public WebViewCallback(int id) {
            super("webViewCallback$" + id);
            this.id = id;
        }

        public Object invoke(KrollInvocation invocation, Object[] args) {
            if (args.length > 0 && args[0] instanceof KrollDict) {
                KrollDict data = (KrollDict)args[0];
                String code = "Ti.executeListener(" + this.id + ", " + data.toString() + ");";
                TiWebViewBinding.this.evalJS(code);
            }
            return KrollProxy.UNDEFINED;
        }
    }

    private class TiReturn {
        private TiReturn() {
        }

        public void setValue(String value) {
            if (value != null) {
                TiWebViewBinding.this.returnValue = value;
            }
            TiWebViewBinding.this.returnSemaphore.release();
        }
    }
}

