/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.webview;

import android.app.Activity;
import android.content.DialogInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import java.lang.ref.SoftReference;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.ui.widget.webview.TiUIWebView;

public class TiWebChromeClient
extends WebChromeClient {
    private static final String LCAT = "TiWebChromeClient";
    private static final boolean DBG = TiConfig.LOGD;
    private SoftReference<Activity> softActivity;
    private boolean isWindow;
    private boolean showProgress;

    public TiWebChromeClient(TiUIWebView webView) {
        this(webView, false, true);
    }

    public TiWebChromeClient(TiUIWebView webView, boolean isWindow, boolean showProgress) {
        this.softActivity = new SoftReference<TiRootActivity>(webView.getProxy().getTiContext().getRootActivity());
        this.isWindow = isWindow;
        this.showProgress = showProgress;
    }

    public void onProgressChanged(WebView view, final int newProgress) {
        Activity activity;
        if (this.isWindow && this.showProgress && (activity = this.softActivity.get()) != null) {
            if (newProgress < 100) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        activity.setProgressBarVisibility(true);
                        activity.setProgressBarIndeterminateVisibility(true);
                        activity.setProgress(newProgress * 100);
                    }
                });
            } else {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        activity.setProgress(newProgress * 100);
                    }
                });
            }
        }
    }

    public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
        TiUIHelper.doOkDialog((String)"Alert", (String)message, (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                result.confirm();
            }
        });
        return true;
    }
}

