/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.webview;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiMimeTypeHelper;
import org.appcelerator.titanium.view.TiBackgroundDrawable;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.webview.TiWebChromeClient;
import ti.modules.titanium.ui.widget.webview.TiWebViewBinding;
import ti.modules.titanium.ui.widget.webview.TiWebViewClient;

public class TiUIWebView
extends TiUIView {
    private static final String LCAT = "TiUIWebView";
    private static final boolean DBG = TiConfig.LOGD;
    private TiWebViewClient client;
    private boolean changingUrl = false;
    private static final char[] escapeChars = new char[]{'%', '#', '\'', '?'};

    public TiUIWebView(TiViewProxy proxy) {
        super(proxy);
        TiWebView webView = new TiWebView(proxy.getContext());
        webView.setVerticalScrollbarOverlay(true);
        WebSettings settings = webView.getSettings();
        settings.setBuiltInZoomControls(true);
        settings.setUseWideViewPort(true);
        settings.setJavaScriptEnabled(true);
        settings.setSupportMultipleWindows(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportZoom(true);
        settings.setLoadsImagesAutomatically(true);
        settings.setLightTouchEnabled(true);
        webView.setWebChromeClient(new TiWebChromeClient(this));
        this.client = new TiWebViewClient(this, webView);
        webView.setWebViewClient(this.client);
        webView.client = this.client;
        TiCompositeLayout.LayoutParams params = this.getLayoutParams();
        params.autoFillsHeight = true;
        params.autoFillsWidth = true;
        this.setNativeView((View)webView);
    }

    public WebView getWebView() {
        return (WebView)this.getNativeView();
    }

    public void processProperties(KrollDict d) {
        Object value;
        super.processProperties(d);
        if (d.containsKey((Object)"scalesPageToFit")) {
            WebSettings settings = this.getWebView().getSettings();
            settings.setLoadWithOverviewMode(TiConvert.toBoolean((KrollDict)d, (String)"scalesPageToFit"));
        }
        if (d.containsKey((Object)"url")) {
            this.setUrl(TiConvert.toString((KrollDict)d, (String)"url"));
        } else if (d.containsKey((Object)"html")) {
            this.setHtml(TiConvert.toString((KrollDict)d, (String)"html"));
        } else if (d.containsKey((Object)"data") && (value = d.get((Object)"data")) instanceof TiBlob) {
            this.setData((TiBlob)value);
        }
        if (this.nativeView != null && this.nativeView.getBackground() instanceof TiBackgroundDrawable) {
            this.nativeView.setBackgroundColor(0);
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        boolean isBgRelated;
        if ("url".equals(key) && !this.changingUrl) {
            this.setUrl(TiConvert.toString((Object)newValue));
        } else if ("html".equals(key)) {
            this.setHtml(TiConvert.toString((Object)newValue));
        } else if ("data".equals(key)) {
            if (newValue instanceof TiBlob) {
                this.setData((TiBlob)newValue);
            }
        } else if ("scalesPageToFit".equals(key)) {
            WebSettings settings = this.getWebView().getSettings();
            settings.setLoadWithOverviewMode(TiConvert.toBoolean((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
        boolean bl = isBgRelated = key.startsWith("background") || key.startsWith("border");
        if (isBgRelated && this.nativeView != null && this.nativeView.getBackground() instanceof TiBackgroundDrawable) {
            this.nativeView.setBackgroundColor(0);
        }
    }

    private boolean mightBeHtml(String url) {
        String mime = TiMimeTypeHelper.getMimeType((String)url);
        if (mime.equals("text/html")) {
            return true;
        }
        return mime.equals("application/xhtml+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrl(String url) {
        TiBaseFile tiFile;
        boolean originalUrlHasScheme;
        String finalUrl = url;
        Uri uri = Uri.parse((String)finalUrl);
        boolean bl = originalUrlHasScheme = uri.getScheme() != null;
        if (!originalUrlHasScheme) {
            finalUrl = this.getProxy().getTiContext().resolveUrl(null, finalUrl);
        }
        if (TiFileFactory.isLocalScheme((String)finalUrl) && this.mightBeHtml(finalUrl) && (tiFile = TiFileFactory.createTitaniumFile((TiContext)this.getProxy().getTiContext(), (String)finalUrl, (boolean)false)) != null) {
            StringBuilder out = new StringBuilder();
            InputStream fis = null;
            try {
                fis = tiFile.getInputStream();
                InputStreamReader reader = new InputStreamReader(fis, "utf-8");
                BufferedReader breader = new BufferedReader(reader);
                boolean injected = false;
                String line = breader.readLine();
                while (line != null) {
                    int posEnd;
                    int pos;
                    if (!injected && (pos = line.indexOf("<html")) >= 0 && (posEnd = line.indexOf(">", pos)) > pos) {
                        out.append(line.substring(pos, posEnd + 1));
                        out.append(TiWebViewBinding.INJECTION_CODE);
                        if (posEnd + 1 < line.length()) {
                            out.append(line.substring(posEnd + 1));
                        }
                        out.append("\n");
                        injected = true;
                        line = breader.readLine();
                        continue;
                    }
                    out.append(line);
                    out.append("\n");
                    line = breader.readLine();
                }
                this.setHtml(out.toString(), originalUrlHasScheme ? url : finalUrl);
                return;
            }
            catch (IOException ioe) {
                Log.e((String)LCAT, (String)("Problem reading from " + url + ": " + ioe.getMessage() + ". Will let WebView try loading it directly."), (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        Log.w((String)LCAT, (String)("Problem closing stream: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (DBG) {
            Log.d((String)LCAT, (String)("WebView will load " + url + " directly without code injection."));
        }
        if (!this.proxy.hasProperty("scalesPageToFit")) {
            this.getWebView().getSettings().setLoadWithOverviewMode(true);
        }
        this.getWebView().loadUrl(finalUrl);
    }

    public void changeProxyUrl(String url) {
        this.changingUrl = true;
        this.getProxy().setProperty("url", (Object)url, true);
        this.changingUrl = false;
    }

    public String getUrl() {
        return this.getWebView().getUrl();
    }

    private String escapeContent(String content) {
        for (char escapeChar : escapeChars) {
            String regex = "\\" + escapeChar;
            content = content.replaceAll(regex, "%" + Integer.toHexString(escapeChar));
        }
        return content;
    }

    public void setHtml(String html) {
        this.setHtml(html, "file:///android_asset/Resources/");
    }

    private void setHtml(String html, String baseUrl) {
        if (!this.proxy.hasProperty("scalesPageToFit")) {
            this.getWebView().getSettings().setLoadWithOverviewMode(false);
        }
        if (html.contains("__ti_injection")) {
            this.getWebView().loadDataWithBaseURL(baseUrl, html, "text/html", "utf-8", null);
            return;
        }
        int tagStart = html.indexOf("<html");
        int tagEnd = -1;
        if (tagStart >= 0 && (tagEnd = html.indexOf(">", tagStart + 1)) > tagStart) {
            StringBuilder sb = new StringBuilder(html.length() + 2500);
            sb.append(html.substring(0, tagEnd + 1));
            sb.append(TiWebViewBinding.INJECTION_CODE);
            sb.append(html.substring(tagEnd + 1));
            this.getWebView().loadDataWithBaseURL(baseUrl, sb.toString(), "text/html", "utf-8", null);
            return;
        }
        this.getWebView().loadDataWithBaseURL(baseUrl, html, "text/html", "utf-8", null);
    }

    public void setData(TiBlob blob) {
        String mimeType = "text/html";
        if (!this.proxy.hasProperty("scalesPageToFit")) {
            this.getWebView().getSettings().setLoadWithOverviewMode(true);
        }
        if (blob.getMimeType() != null) {
            mimeType = blob.getMimeType();
        }
        if (TiMimeTypeHelper.isBinaryMimeType((String)mimeType)) {
            this.getWebView().loadData(blob.toBase64(), mimeType, "base64");
        } else {
            this.getWebView().loadData(this.escapeContent(new String(blob.getBytes())), mimeType, "utf-8");
        }
    }

    public String getJSValue(String expression) {
        return this.client.getBinding().getJSValue(expression);
    }

    public void setBasicAuthentication(String username, String password) {
        this.client.setBasicAuthentication(username, password);
    }

    public boolean canGoBack() {
        return this.getWebView().canGoBack();
    }

    public boolean canGoForward() {
        return this.getWebView().canGoForward();
    }

    public void goBack() {
        this.getWebView().goBack();
    }

    public void goForward() {
        this.getWebView().goForward();
    }

    public void reload() {
        this.getWebView().reload();
    }

    public void stopLoading() {
        this.getWebView().stopLoading();
    }

    private class TiWebView
    extends WebView {
        public TiWebViewClient client;

        public TiWebView(Context context) {
            super(context);
        }

        public void destroy() {
            if (this.client != null) {
                this.client.getBinding().destroy();
            }
            super.destroy();
        }
    }
}

