/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.ui.widget.tableview.TiBaseTableViewItem;

public class TiTableViewSelector
extends Drawable {
    private static final String LCAT = "TiTableViewSelector";
    private static final boolean DBG = TiConfig.LOGD;
    private ListView listView;
    private Drawable defaultDrawable;
    private Drawable selectedDrawable;

    public TiTableViewSelector(ListView listView) {
        this.listView = listView;
        if (Build.VERSION.SDK_INT >= 11) {
            this.defaultDrawable = new StateListDrawable();
            ((StateListDrawable)this.defaultDrawable).addState(new int[]{16842919}, (Drawable)new ColorDrawable(-1));
            ((StateListDrawable)this.defaultDrawable).addState(new int[0], (Drawable)new ColorDrawable(0));
        } else {
            this.defaultDrawable = listView.getSelector();
        }
        this.selectedDrawable = this.defaultDrawable;
        listView.setOnTouchListener((View.OnTouchListener)new TouchListener());
    }

    public Drawable getRowDrawable(View row) {
        TiBaseTableViewItem rowView;
        Drawable rowDrawable = null;
        if (row instanceof TiBaseTableViewItem && (rowView = (TiBaseTableViewItem)row).hasSelector()) {
            rowDrawable = rowView.getSelectorDrawable();
        }
        if (rowDrawable == null) {
            rowDrawable = this.defaultDrawable;
        }
        return rowDrawable;
    }

    public void draw(Canvas canvas) {
        if (!this.listView.isInTouchMode()) {
            this.selectedDrawable = this.getRowDrawable(this.listView.getSelectedView());
            this.selectedDrawable.setBounds(this.getBounds());
        }
        this.selectedDrawable.draw(canvas);
    }

    public boolean setState(int[] stateSet) {
        super.setState(stateSet);
        return this.selectedDrawable.setState(stateSet);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.selectedDrawable.setBounds(left, top, right, bottom);
    }

    public void setBounds(Rect bounds) {
        super.setBounds(bounds);
        this.selectedDrawable.setBounds(bounds);
    }

    public int getOpacity() {
        return this.selectedDrawable.getOpacity();
    }

    public void setAlpha(int alpha) {
        this.selectedDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.selectedDrawable.setColorFilter(colorFilter);
    }

    class TouchListener
    implements View.OnTouchListener {
        TouchListener() {
        }

        public boolean onTouch(View view, MotionEvent event) {
            if (event.getAction() == 0) {
                int touchPosition = TiTableViewSelector.this.listView.pointToPosition((int)event.getX(), (int)event.getY());
                TiTableViewSelector.this.selectedDrawable = TiTableViewSelector.this.getRowDrawable(TiTableViewSelector.this.listView.getChildAt(touchPosition - TiTableViewSelector.this.listView.getFirstVisiblePosition()));
            } else if (event.getAction() == 1) {
                TiTableViewSelector.this.selectedDrawable = TiTableViewSelector.this.defaultDrawable;
            }
            return false;
        }
    }
}

