/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Map;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.LabelProxy;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.TableViewRowProxy;
import ti.modules.titanium.ui.widget.TiUILabel;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;
import ti.modules.titanium.ui.widget.tableview.TiBaseTableViewItem;
import ti.modules.titanium.ui.widget.tableview.TiTableViewColorSelector;

public class TiTableViewRowProxyItem
extends TiBaseTableViewItem {
    private static final String LCAT = "TitaniumTableViewItem";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int LEFT_MARGIN = 5;
    private static final int RIGHT_MARGIN = 7;
    private BitmapDrawable hasChildDrawable;
    private BitmapDrawable hasCheckDrawable;
    private ImageView leftImage;
    private ImageView rightImage;
    private TiCompositeLayout content;
    private ArrayList<TiUIView> views;
    private boolean hasControls;
    private TiDimension height = null;
    private TableViewModel.Item item;
    private Object selectorSource;
    private Drawable selectorDrawable;
    private static String[] filteredProperties = new String[]{"backgroundImage", "backgroundColor", "backgroundSelectedImage", "backgroundSelectedColor"};

    public TiTableViewRowProxyItem(TiContext tiContext) {
        super(tiContext);
        this.handler = new Handler((Handler.Callback)this);
        this.leftImage = new ImageView((Context)tiContext.getActivity());
        this.leftImage.setVisibility(8);
        this.addView((View)this.leftImage, new ViewGroup.LayoutParams(-2, -2));
        this.content = new TiCompositeLayout((Context)tiContext.getActivity());
        this.content.setMinimumHeight(48);
        this.addView((View)this.content, new ViewGroup.LayoutParams(-1, -1));
        this.rightImage = new ImageView((Context)tiContext.getActivity());
        this.rightImage.setVisibility(8);
        this.addView((View)this.rightImage, new ViewGroup.LayoutParams(-2, -2));
    }

    protected TableViewRowProxy getRowProxy() {
        return (TableViewRowProxy)this.item.proxy;
    }

    @Override
    public void setRowData(TableViewModel.Item item) {
        this.item = item;
        TableViewRowProxy rp = this.getRowProxy();
        rp.setTableViewItem(this);
        this.setRowData(rp);
    }

    @Override
    public TableViewModel.Item getRowData() {
        return this.item;
    }

    protected TiViewProxy addViewToOldRow(int index, TiUIView titleView, TiViewProxy newViewProxy) {
        if (DBG) {
            Log.w((String)LCAT, (String)(newViewProxy + " was added an old style row, reusing the title TiUILabel"));
        }
        LabelProxy label = new LabelProxy(this.tiContext);
        label.handleCreationDict(titleView.getProxy().getProperties());
        label.setView(titleView);
        label.setModelListener((KrollProxyListener)titleView);
        titleView.setProxy((TiViewProxy)label);
        this.getRowProxy().getControls().add(index, label);
        this.views.add(newViewProxy.getView(this.tiContext.getActivity()));
        return label;
    }

    protected void refreshControls() {
        ArrayList<TiViewProxy> proxies = this.getRowProxy().getControls();
        int len = proxies.size();
        if (this.views == null) {
            this.views = new ArrayList(len);
        } else if (this.views.size() != len) {
            for (TiUIView view : this.views) {
                View v = view.getNativeView();
                if (v == null || !v.getParent().equals(this.content)) continue;
                this.content.removeView(v);
            }
            this.views = new ArrayList(len);
        }
        for (int i = 0; i < len; ++i) {
            TiUIView view;
            view = this.views.size() > i ? this.views.get(i) : null;
            TiViewProxy proxy = proxies.get(i);
            if (view != null && view.getProxy() instanceof TableViewRowProxy) {
                proxy = this.addViewToOldRow(i, view, proxy);
                ++len;
            }
            if (view == null) {
                view = proxy.forceCreateView(this.tiContext.getActivity());
                this.clearChildViews(proxy);
                if (i >= this.views.size()) {
                    this.views.add(view);
                } else {
                    this.views.set(i, view);
                }
            }
            View v = view.getNativeView();
            view.setProxy(proxy);
            view.processProperties(proxy.getProperties());
            this.applyChildProxies(proxy, view);
            if (v.getParent() != null) continue;
            this.content.addView(v, (ViewGroup.LayoutParams)view.getLayoutParams());
        }
    }

    protected void clearChildViews(TiViewProxy parent) {
        for (TiViewProxy childProxy : parent.getChildren()) {
            childProxy.setView(null);
            this.clearChildViews(childProxy);
        }
    }

    protected void applyChildProxies(TiViewProxy viewProxy, TiUIView view) {
        int i = 0;
        TiViewProxy[] childProxies = viewProxy.getChildren();
        for (TiUIView childView : view.getChildren()) {
            TiViewProxy childProxy = childProxies[i];
            childView.setProxy(childProxy);
            childView.processProperties(childProxy.getProperties());
            this.applyChildProxies(childProxy, childView);
            ++i;
        }
    }

    protected void refreshOldStyleRow() {
        TableViewRowProxy rp = this.getRowProxy();
        if (!rp.hasProperty("touchEnabled")) {
            rp.setProperty("touchEnabled", false);
        }
        if (this.views == null) {
            this.views = new ArrayList();
            this.views.add(new TiUILabel(rp));
        }
        TiUILabel t = (TiUILabel)this.views.get(0);
        t.setProxy(rp);
        t.processProperties(this.filterProperties(rp.getProperties()));
        View v = t.getNativeView();
        if (v.getParent() == null) {
            TiCompositeLayout.LayoutParams params = t.getLayoutParams();
            params.optionLeft = new TiDimension(5.0, 0);
            params.optionRight = new TiDimension(5.0, 2);
            params.autoFillsWidth = true;
            this.content.addView(v, (ViewGroup.LayoutParams)params);
        }
    }

    public void setRowData(TableViewRowProxy rp) {
        String path;
        String url;
        Drawable d;
        KrollDict props = rp.getProperties();
        this.hasControls = rp.hasControls();
        Object newSelectorSource = null;
        if (rp.hasProperty("backgroundSelectedImage")) {
            newSelectorSource = rp.getProperty("backgroundSelectedImage");
        } else if (rp.hasProperty("backgroundSelectedColor")) {
            newSelectorSource = rp.getProperty("backgroundSelectedColor");
        }
        if (newSelectorSource == null || this.selectorSource != null && !this.selectorSource.equals(newSelectorSource)) {
            this.selectorDrawable = null;
        }
        this.selectorSource = newSelectorSource;
        if (this.selectorSource != null) {
            rp.getTable().getTableView().getTableView().enableCustomSelector();
        }
        this.setBackgroundFromProperties(props);
        boolean clearRightImage = true;
        if (props.containsKey((Object)"hasCheck") && TiConvert.toBoolean((KrollDict)props, (String)"hasCheck")) {
            if (this.hasCheckDrawable == null) {
                this.hasCheckDrawable = this.createHasCheckDrawable();
            }
            this.rightImage.setImageDrawable((Drawable)this.hasCheckDrawable);
            this.rightImage.setVisibility(0);
            clearRightImage = false;
        }
        if (props.containsKey((Object)"hasChild") && TiConvert.toBoolean((KrollDict)props, (String)"hasChild")) {
            if (this.hasChildDrawable == null) {
                this.hasChildDrawable = this.createHasChildDrawable();
            }
            this.rightImage.setImageDrawable((Drawable)this.hasChildDrawable);
            this.rightImage.setVisibility(0);
            clearRightImage = false;
        }
        if (props.containsKey((Object)"rightImage") && (d = this.loadDrawable(url = this.tiContext.resolveUrl(null, path = TiConvert.toString((KrollDict)props, (String)"rightImage")))) != null) {
            this.rightImage.setImageDrawable(d);
            this.rightImage.setVisibility(0);
            clearRightImage = false;
        }
        if (clearRightImage) {
            this.rightImage.setImageDrawable(null);
            this.rightImage.setVisibility(8);
        }
        if (props.containsKey((Object)"leftImage")) {
            path = TiConvert.toString((KrollDict)props, (String)"leftImage");
            url = this.tiContext.resolveUrl(null, path);
            d = this.loadDrawable(url);
            if (d != null) {
                this.leftImage.setImageDrawable(d);
                this.leftImage.setVisibility(0);
            }
        } else {
            this.leftImage.setImageDrawable(null);
            this.leftImage.setVisibility(8);
        }
        if (props.containsKey((Object)"height") && !props.get((Object)"height").equals("auto")) {
            this.height = TiConvert.toTiDimension((String)TiConvert.toString((KrollDict)props, (String)"height"), (int)7);
        }
        if (props.containsKey((Object)"layout")) {
            this.content.setLayoutArrangement(TiConvert.toString((KrollDict)props, (String)"layout"));
        }
        if (rp.hasControls()) {
            this.refreshControls();
        } else {
            this.refreshOldStyleRow();
        }
    }

    protected boolean hasView(TiUIView view) {
        if (this.views == null) {
            return false;
        }
        for (TiUIView v : this.views) {
            if (v != view) continue;
            return true;
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int imageHMargin = 0;
        int leftImageWidth = 0;
        int leftImageHeight = 0;
        if (this.leftImage != null && this.leftImage.getVisibility() != 8) {
            this.measureChild((View)this.leftImage, widthMeasureSpec, heightMeasureSpec);
            leftImageWidth = this.leftImage.getMeasuredWidth();
            leftImageHeight = this.leftImage.getMeasuredHeight();
            imageHMargin += 5;
        }
        int rightImageWidth = 0;
        int rightImageHeight = 0;
        if (this.rightImage != null && this.rightImage.getVisibility() != 8) {
            this.measureChild((View)this.rightImage, widthMeasureSpec, heightMeasureSpec);
            rightImageWidth = this.rightImage.getMeasuredWidth();
            rightImageHeight = this.rightImage.getMeasuredHeight();
            imageHMargin += 7;
        }
        int adjustedWidth = w - leftImageWidth - rightImageWidth - imageHMargin;
        if (this.content != null) {
            this.measureChild((View)this.content, View.MeasureSpec.makeMeasureSpec((int)adjustedWidth, (int)wMode), heightMeasureSpec);
            if (hMode == 0) {
                TableViewProxy table = ((TableViewRowProxy)this.item.proxy).getTable();
                int minRowHeight = -1;
                if (table != null && table.hasProperty("minRowHeight")) {
                    minRowHeight = TiConvert.toTiDimension((String)TiConvert.toString((Object)table.getProperty("minRowHeight")), (int)7).getAsPixels((View)this);
                }
                if (this.height == null) {
                    h = Math.max(h, Math.max(this.content.getMeasuredHeight(), Math.max(leftImageHeight, rightImageHeight)));
                    h = Math.max(h, minRowHeight);
                } else {
                    h = Math.max(minRowHeight, this.height.getAsPixels((View)this));
                }
                if (DBG) {
                    Log.d((String)LCAT, (String)("Row content measure (" + adjustedWidth + "x" + h + ")"));
                }
                this.measureChild((View)this.content, View.MeasureSpec.makeMeasureSpec((int)adjustedWidth, (int)wMode), View.MeasureSpec.makeMeasureSpec((int)h, (int)hMode));
            }
        }
        this.setMeasuredDimension(w, Math.max(h, Math.max(leftImageHeight, rightImageHeight)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int offset;
        int h;
        int w;
        int contentLeft = left;
        int contentRight = right;
        bottom -= top;
        top = 0;
        int height = bottom - top;
        if (this.leftImage != null && this.leftImage.getVisibility() != 8) {
            w = this.leftImage.getMeasuredWidth();
            h = this.leftImage.getMeasuredHeight();
            int leftMargin = 5;
            contentLeft += w + leftMargin;
            offset = (height - h) / 2;
            this.leftImage.layout(left + leftMargin, top + offset, left + leftMargin + w, top + offset + h);
        }
        if (this.rightImage != null && this.rightImage.getVisibility() != 8) {
            w = this.rightImage.getMeasuredWidth();
            h = this.rightImage.getMeasuredHeight();
            int rightMargin = 7;
            contentRight -= w + rightMargin;
            offset = (height - h) / 2;
            this.rightImage.layout(right - w - rightMargin, top + offset, right - rightMargin, top + offset + h);
        }
        if (this.hasControls) {
            contentLeft = left + 5;
            contentRight = right - 7;
        }
        if (this.content != null) {
            this.content.layout(contentLeft, top, contentRight, bottom);
        }
    }

    private KrollDict filterProperties(KrollDict d) {
        if (d == null) {
            return new KrollDict();
        }
        KrollDict filtered = new KrollDict((Map)d);
        for (int i = 0; i < filteredProperties.length; ++i) {
            if (!filtered.containsKey((Object)filteredProperties[i])) continue;
            filtered.remove((Object)filteredProperties[i]);
        }
        return filtered;
    }

    @Override
    public boolean hasSelector() {
        KrollDict d = this.getRowProxy().getProperties();
        return d.containsKey((Object)"backgroundSelectedImage") || d.containsKey((Object)"backgroundSelectedColor");
    }

    @Override
    public Drawable getSelectorDrawable() {
        TableViewRowProxy rowProxy = this.getRowProxy();
        if (this.selectorDrawable == null && this.selectorSource != null) {
            if (rowProxy.hasProperty("backgroundSelectedImage")) {
                String path = TiConvert.toString((Object)rowProxy.getProperty("backgroundSelectedImage"));
                String url = rowProxy.getTiContext().resolveUrl(null, path);
                this.selectorDrawable = this.loadDrawable(url);
            } else if (rowProxy.hasProperty("backgroundSelectedColor")) {
                int color = TiConvert.toColor((KrollDict)rowProxy.getProperties(), (String)"backgroundSelectedColor");
                this.selectorDrawable = new TiTableViewColorSelector(color);
            }
        }
        return this.selectorDrawable;
    }

    @Override
    public void release() {
        super.release();
        if (this.views != null) {
            for (TiUIView view : this.views) {
                view.release();
            }
            this.views = null;
        }
        if (this.content != null) {
            this.content.removeAllViews();
            this.content = null;
        }
        if (this.hasCheckDrawable != null) {
            this.hasCheckDrawable.setCallback(null);
            this.hasCheckDrawable = null;
        }
        if (this.hasChildDrawable != null) {
            this.hasChildDrawable.setCallback(null);
            this.hasChildDrawable = null;
        }
    }
}

